#ifndef K3DUI_SPLASH_BOX_H
#define K3DUI_SPLASH_BOX_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3d::splash_box class, which provides a standardized "splash" box for K-3D
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/signal_system.h>
#include <sdpgtk/sdpgtkobjectcontainer.h>

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// splash_box

/// Creates a modal "splash" box that displays program version and copyright
class splash_box :
	public sdpGtkObjectContainer,
	public SigC::Object
{
public:
	splash_box();
	~splash_box();

	void on_startup_message(const std::string Message);
};

} // namespace k3d

#endif // K3DUI_SPLASH_BOX_H

