#include "bounding_box.h"

namespace k3d
{

bool operator==(const bounding_box3& LHS, const bounding_box3& RHS)
{
	return LHS.nx == RHS.nx && LHS.px == RHS.px && LHS.ny == RHS.ny && LHS.py == RHS.py && LHS.nz == RHS.nz && LHS.pz == RHS.pz;
}

bool operator!=(const bounding_box3& LHS, const bounding_box3& RHS)
{
	return !(LHS == RHS);
}

std::ostream& operator<<(std::ostream& Stream, const bounding_box3& RHS)
{
	Stream << RHS.nx << " " << RHS.px << " " << RHS.ny << " " << RHS.py << " " << RHS.nz << " " << RHS.pz;
	return Stream;
}

std::istream& operator>>(std::istream& Stream, bounding_box3& RHS)
{
	Stream >> RHS.nx >> RHS.px >> RHS.ny >> RHS.py >> RHS.nz >> RHS.pz;
	return Stream;
}

} // namespace k3d

