// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
          \author Anders Dahnielson (anders@dahnielson.com)
*/

#include <k3dsdk/i18n.h>
#include <k3dsdk/module.h>

#include "bitmap_composite_simple.h"

namespace libk3dbitmap
{

/////////////////////////////////////////////////////////////////////////////
// bitmap_image_over

class bitmap_image_over :
	public bitmap_composite_simple
{
	typedef bitmap_composite_simple base;

public:
	bitmap_image_over(k3d::idocument& Document) :
		base(Document)
	{
	}

	void on_value_change() {}

	void on_composite(const k3d::pixel& A, const k3d::pixel& B, k3d::pixel& O)
	{
		double invmat = k3d::pixel::sample_traits::invert(A.alpha);
		
		O.red   = A.red   + (invmat * B.red);
		O.green = A.green + (invmat * B.green);
		O.blue  = A.blue  + (invmat * B.blue);
		O.alpha = A.alpha + (invmat * B.alpha);
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<
			k3d::document_plugin<bitmap_image_over>,
			k3d::interface_list<k3d::ibitmap_source,
			k3d::interface_list<k3d::ibitmap_sink> > > factory(
				k3d::uuid(0xfd5811d8, 0x582d4fbb, 0xb7a16cbe, 0x62d375f9),
				"BitmapImageOver",
				_("Lays image on top of another"),
				"Bitmap",
				k3d::iplugin_factory::STABLE);

		return factory;
	}
};

/////////////////////////////////////////////////////////////////////////////
// bitmap_image_over_factory

k3d::iplugin_factory& bitmap_image_over_factory()
{
	return bitmap_image_over::get_factory();
}

} // namespace libk3dbitmap

