// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements procedures required to export K-3D objects from the core module
		\author Timothy M. Shead (tshead@k-3d.com)
*/

#include <k3dsdk/module.h>

/// Namespace reserved for the core plugin module, to protect public symbols from name clashes with other modules
namespace libk3dcore
{

extern k3d::iplugin_factory& annotation_factory();
extern k3d::iplugin_factory& axes_factory();
extern k3d::iplugin_factory& camera_factory();
extern k3d::iplugin_factory& color_property_factory();
extern k3d::iplugin_factory& cone_factory();
extern k3d::iplugin_factory& cylinder_factory();
extern k3d::iplugin_factory& disk_factory();
extern k3d::iplugin_factory& document_reader_factory();
extern k3d::iplugin_factory& document_writer_factory();
extern k3d::iplugin_factory& format_scalar_factory();
extern k3d::iplugin_factory& format_time_factory();
extern k3d::iplugin_factory& frozen_transformation_factory();
extern k3d::iplugin_factory& hyperboloid_factory();
extern k3d::iplugin_factory& look_at_factory();
extern k3d::iplugin_factory& orientation_factory();
extern k3d::iplugin_factory& paraboloid_factory();
extern k3d::iplugin_factory& position_factory();
extern k3d::iplugin_factory& print_stdout_factory();
extern k3d::iplugin_factory& scalar_add_factory();
extern k3d::iplugin_factory& scalar_div_factory();
extern k3d::iplugin_factory& scalar_modulo_factory();
extern k3d::iplugin_factory& scalar_multiply_factory();
extern k3d::iplugin_factory& scalar_property_factory();
extern k3d::iplugin_factory& scalar_rand_factory();
extern k3d::iplugin_factory& scalar_sine_factory();
extern k3d::iplugin_factory& scalar_sub_factory();
extern k3d::iplugin_factory& scale_factory();
extern k3d::iplugin_factory& show_matrix_factory();
extern k3d::iplugin_factory& sphere_factory();
extern k3d::iplugin_factory& torus_factory();

} // namespace libk3dcore

K3D_MODULE_START(libk3dcore, k3d::uuid(0xcec1a6bd, 0xc0134093, 0xa44907d8, 0x6978249b), Registry)
	Registry.register_factory(libk3dcore::annotation_factory());
	Registry.register_factory(libk3dcore::axes_factory());
	Registry.register_factory(libk3dcore::camera_factory());
	Registry.register_factory(libk3dcore::color_property_factory());
	Registry.register_factory(libk3dcore::cone_factory());
	Registry.register_factory(libk3dcore::cylinder_factory());
	Registry.register_factory(libk3dcore::disk_factory());
	Registry.register_factory(libk3dcore::document_reader_factory());
	Registry.register_factory(libk3dcore::document_writer_factory());
	Registry.register_factory(libk3dcore::format_scalar_factory());
	Registry.register_factory(libk3dcore::format_time_factory());
	Registry.register_factory(libk3dcore::frozen_transformation_factory());
	Registry.register_factory(libk3dcore::hyperboloid_factory());
	Registry.register_factory(libk3dcore::look_at_factory());
	Registry.register_factory(libk3dcore::orientation_factory());
	Registry.register_factory(libk3dcore::paraboloid_factory());
	Registry.register_factory(libk3dcore::position_factory());
	Registry.register_factory(libk3dcore::print_stdout_factory());
	Registry.register_factory(libk3dcore::scalar_add_factory());
	Registry.register_factory(libk3dcore::scalar_div_factory());
	Registry.register_factory(libk3dcore::scalar_modulo_factory());
	Registry.register_factory(libk3dcore::scalar_multiply_factory());
	Registry.register_factory(libk3dcore::scalar_property_factory());
	Registry.register_factory(libk3dcore::scalar_rand_factory());
	Registry.register_factory(libk3dcore::scalar_sine_factory());
	Registry.register_factory(libk3dcore::scalar_sub_factory());
	Registry.register_factory(libk3dcore::scale_factory());
	Registry.register_factory(libk3dcore::show_matrix_factory());
	Registry.register_factory(libk3dcore::sphere_factory());
	Registry.register_factory(libk3dcore::torus_factory());
K3D_MODULE_END


