// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements the k3d::bitmap_preview namespace, which provides a MVC UI for boolean data sources
		\author Tim Shead (tshead@k-3d.com)
*/

#include "bitmap_preview.h"

#include <gdkmm/pixbuf.h>
#include <gtkmm/image.h>

namespace libk3dngui
{

namespace bitmap_preview
{

/////////////////////////////////////////////////////////////////////////////
// control

control::control(k3d::icommand_node& Parent, const std::string& Name, std::auto_ptr<idata_proxy> Data) :
	base(true, 0),
	ui_component(Name, &Parent),
	m_image(new Gtk::Image()),
//	m_alpha(new Gtk::Image()),
	m_data(Data)
{
	pack_start(*manage(m_image), Gtk::PACK_SHRINK);
//	pack_start(*manage(m_alpha), Gtk::PACK_SHRINK);

	data_changed();
	if(m_data.get())
		m_data->changed_signal().connect(sigc::mem_fun(*this, &control::data_changed));
}

void control::data_changed()
{
	return_if_fail(m_data.get());

	m_buffer.reset(64, 64);
	if(m_data->value())
		{
			k3d::scale_bitmap(*m_data->value(), m_buffer);
		}
	else
		{
			k3d::checkerboard_fill(m_buffer, 8, 8, buffer_t::pixel_type(32, 32, 32, 255), buffer_t::pixel_type(210, 210, 210, 255));
		}

	m_image->set(
		Gdk::Pixbuf::create_from_data(reinterpret_cast<guint8*>(m_buffer.data()),
		Gdk::COLORSPACE_RGB,
		true,
		8,
		m_buffer.width(),
		m_buffer.height(),
		m_buffer.width() * 4));
}

} // namespace bitmap_preview

} // namespace k3d


