// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "application_state.h"
#include "widget_manip.h"

#include <gtkmm/label.h>
#include <gtkmm/messagedialog.h>

namespace libk3dngui
{

void message(const std::string& Message, const std::string& Title)
{
	return_if_fail(!application_state().batch_mode());
	Gtk::MessageDialog(Message, false, Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true).run();
}

void error_message(const std::string& Message, const std::string& Title)
{
	return_if_fail(!application_state().batch_mode());
	Gtk::MessageDialog(Message, false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true).run();
}

unsigned int query_message(const std::string& Message, const std::string& Title, const unsigned int DefaultButton, const std::vector<std::string> Buttons)
{
	return_val_if_fail(!application_state().batch_mode(), 0);

	Gtk::Dialog dialog(Title, true);
	dialog.get_vbox()->pack_start(*Gtk::manage(new Gtk::Label(Message) << line_wrap()));

	for(unsigned long i = 0; i != Buttons.size(); ++i)
		dialog.add_button(Buttons[i], i+1);

	if(DefaultButton)
		dialog.set_default_response(DefaultButton-1);
	else
		dialog.set_default_response(Buttons.size());

	dialog.show_all();
	int result = dialog.run();
	if(Gtk::RESPONSE_DELETE_EVENT == result)
		result = 0;

	return result;
}

} // namespace libk3dngui

