#ifndef NGUI_MESSAGES_H
#define NGUI_MESSAGES_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <string>
#include <vector>

namespace libk3dngui
{

/// Displays an informational message in a modal dialog box
void message(const std::string& Message, const std::string& Title);
/// Displays an error message in a modal dialog box
void error_message(const std::string& Message, const std::string& Title);
/**
	 \brief Prompts the user to choose one of selections in a modal dialog box
	 \param Message the text displayed by the message box.
	 \param Title the title of the dialog box.
	 \param DefaultButton one-based index of the button that is selected by default.  If DefaultButton is 0, then no button is selected by default.
	 \return one-based index of the button selected by the user, or "0" if a choice was not made (e.g. user clicked WM "close" button)
*/
unsigned int query_message(const std::string& Message, const std::string& Title, const unsigned int DefaultButton, const std::vector<std::string> Buttons);

} // namespace libk3dngui

#endif // !NGUI_MESSAGES_H


