#ifndef NGUI_TUTORIAL_MESSAGE_H
#define NGUI_TUTORIAL_MESSAGE_H

// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares functions for displaying a "Tutorial Message" dialog that prompts the user and provides feedback during interactive tutorial playback
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/iuser_interface.h>

namespace libk3dngui
{

/// Does one-time initialization of the tutorial message system for speed
void initialize_tutorial_messages();
/// Implements the corresponding k3d::iuser_interface method
bool tutorial_message(const std::string& Message);
/// Implements the corresponding k3d::iuser_interface method
void tutorial_mouse_message(const std::string& Message, const k3d::iuser_interface::mouse_action_t Action, const k3d::key_modifiers Modifiers);

} // namespace libk3dngui

#endif // NGUI_TUTORIAL_MESSAGE_H


