#ifndef NGUI_USER_INTERFACE_H
#define NGUI_USER_INTERFACE_H

// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/data.h>

namespace libk3dngui
{

class user_interface
{
public:
	virtual k3d_data(bool, no_name, change_signal, no_undo, local_storage, no_constraint, no_property, no_serialization)& black_box_recorder() = 0;

protected:
	user_interface() {}
	user_interface(const user_interface&) {}
	user_interface& operator=(const user_interface&) { return *this; }
	virtual ~user_interface() {}
};

} // namespace libk3dngui

#endif // NGUI_USER_INTERFACE_H


