#python

import k3d

doc = k3d.Document
doc.start_change_set()
try:
	material = doc.new_object("RenderManMaterial")
	material.name = "Group Material"
	material.color = (1, 1, 1)

	frozen_mesh = doc.new_object("FrozenMesh")
	frozen_mesh.name = "Point Group"

	mesh = frozen_mesh.new_mesh()

	points = ((0, 5, 5), (5, 5, -5), (-5, -5, 0), (5, -5, 0))
	for position in points:
		mesh.new_point(position)

	group = mesh.new_point_group()
	group.material = material

	for i in range(4):
		group.points[i] = mesh.points[i]

#	group.constant_data.set_color("Cs", (1, 1, 0))
	group.constant_data.set_real("constantwidth", 0.5);
	
	mesh_instance = doc.new_object("MeshInstance")
	mesh_instance.name = "Point Group Instance"
	doc.set_dependency(mesh_instance.get_property("input_mesh"), frozen_mesh.get_property("output_mesh"))

	doc.finish_change_set("Create Point Group")

except:
	doc.cancel_change_set()
	raise

