#python

import k3d
import sys

def dump_object(Object, File):
	File.write("# " + Object.name + "\n")

	if not Object.get_property("output_mesh"):
		return

	mesh = Object.output_mesh

	for polyhedron in mesh.polyhedra:
		File.write(str(len(mesh.points)) + " " + str(len(polyhedron.faces)) + "\n")

		point_map = {}

		for point in mesh.points:
			point_map[point] = len(point_map)
			position = point.position
			File.write(str(position[0]) + " " + str(position[1]) + " " + str(position[2]) + "\n")

		for face in polyhedron.faces:
			edge = face.first_edge
			while edge:
				File.write(str(point_map[edge.vertex]) + " ")
				edge = edge.face_clockwise
				if edge == face.first_edge:
					break
			File.write("\n")

	File.write("\n")

def export():
	if not k3d.Document:
		k3d.Application.ui.error_message("No document to export!")
		return

	filepath = k3d.Application.ui.get_file_path("write", "documents", "Export RAW:", "")
	if filepath == "":
		return

	try:
		exportfile = open(filepath, "w")
	except IOError:
		k3d.Application.ui.error_message("Couldn't open file!")
		return

	for object in k3d.Document.objects:
		dump_object(object, exportfile)

	exportfile.close()

export()

