#include <iostream>
#include <boost/filesystem/path.hpp>

template<typename name_check_type>
void test(const std::string& Type, const std::string& Path, name_check_type name_check)
{
	std::cout << "\t" << Type << ": ";
	try
	{
		boost::filesystem::path path(Path, name_check);
		std::copy(path.begin(), path.end(), std::ostream_iterator<std::string>(std::cout, "   "));
		std::cout << std::endl;
	}
	catch(std::exception& e)
	{
		std::cout << "exception: " << e.what() << std::endl;
	}
}

void test(const std::string& Path)
{
	std::cout << "testing: " << Path << std::endl;

	test("portable_posix_name", Path, boost::filesystem::portable_posix_name);
	test("windows_name", Path, boost::filesystem::windows_name);
	test("portable_name", Path, boost::filesystem::portable_name);
	test("no_check", Path, boost::filesystem::no_check);
	test("native", Path, boost::filesystem::native);
}

int main(int argc, char* argv[])
{
	test("/home/tshead/foo");
	test("/home/tshead/foo^");
	test("/home/tshead\\foo");
	test("c:\\home\\tshead\\foo");

	return 0;
}

