/***************************************************************************
 *   Copyright (C) 2005 by Jean-Michel Petit                               *
 *   jm_petit@laposte.net                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdint.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qapplication.h>
#include <qprogressbar.h>
#include <qlabel.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#include <kguiitem.h>

#include "k9backupdlg.h"


k9BackupDlg::k9BackupDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
        : backupDlg(parent,name, modal,fl) {
    Abort=false;
    timer = new QTimer( this );
    time = new QTime(0,0);
    time->start();
    connect( timer, SIGNAL(timeout()), this, SLOT(timerDone()) );
    timer->start( 1000, 0 );
    bAbort->setIconSet(KStdGuiItem::cancel().iconSet());
    totalCopied=0;
}


k9BackupDlg::~k9BackupDlg() {
    delete timer;
    delete time;
}

void k9BackupDlg::timerDone() {
    QTime time2(0,0);
    time2=time2.addMSecs(time->elapsed());
    lblTime->setText(time2.toString("hh:mm:ss"));
}

void k9BackupDlg::setTotalSteps(uint32_t _totalSteps) {
    pbStep->setTotalSteps(_totalSteps);
    qApp->processEvents();
}

void k9BackupDlg::setProgress(uint32_t _position) {
    pbStep->setProgress(_position);
    qApp->processEvents();
}

void k9BackupDlg::setTotalMax(uint32_t _max) {
    pbTotal->setTotalSteps(_max);
    qApp->processEvents();
}

void k9BackupDlg::setProgressTotal(uint32_t _position) {
   totalCopied+=_position;
   uint64_t total=totalCopied*2048;
   total/=(1024*1024);
    pbTotal->setProgress(total);
}

void k9BackupDlg::setProgressLabel(QString _text) {
    lblStep->setText(_text);
}

bool k9BackupDlg::getAbort() {
    return Abort;
}

void k9BackupDlg::bAbortClick() {
    Abort=true;
    reject();

}

void k9BackupDlg::setFactor(QString _factor) {
    lblFactor->setText(_factor);
}
/*$SPECIALIZATION$*/


#include "k9backupdlg.moc"
