/***************************************************************************
*   Copyright (C) 2005 by Jean-Michel Petit                               *
*   jm_petit@laposte.net                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef K9DVDBACKUP_H
#define K9DVDBACKUP_H

#include <qobject.h>
#include <kprocess.h>
#include <qfile.h>
#include <qobjectlist.h>
#include "k9cell.h"
#include <dvdread/ifo_types.h>
#include <stdint.h>
#include "k9cellcopylist.h"
/**
@author Jean-Michel Petit
*/

class k9BackupDlg;

class k9TitleSet : public QObject {
    Q_OBJECT
public:
    k9TitleSet(int _VTS);
    ~k9TitleSet();
    uint32_t startSector;
    uint32_t lastSector;
    int VTS;
    k9CellList cells;
    k9Cell*addCell(int _vts,int _pgc, int _vob);
    uint32_t getSize();
    ifo_handle_t *ifoTitle;
private:
};

class k9TitleSetList:public QPtrList <k9TitleSet> {
protected:
	 int compareItems ( QPtrCollection::Item item1, QPtrCollection::Item item2 );
};

class k9DVDBackup : public QObject {
    Q_OBJECT
public:
    k9DVDBackup(QObject  *_dvd,const char* name=0,const QStringList& args=0) ;

    ~k9DVDBackup();
    virtual void setDevice(QString _device);
    virtual void setOutput(QString _output);
    virtual QString getErrMsg();
    virtual void execute();
    virtual bool geterror();
private slots:
    void receivedStdout (KProcess * proc, char * buffer, int buflen);
    void receivedStderr(KProcess * proc, char * buffer, int buflen);
    void wroteStdin (KProcess * proc);
protected:
    QString device;
    QString output;
    bool wrote;
private:
    dvd_reader_t *m_dvdhandle;
    k9DVD *DVD;
    QString errMsg;
    QString vampsMsg;
    QFile* outputFile;
    long cellSize;
    long currVTS;
    k9TitleSet *currTS;
    int currVOB;
    k9Cell *currCell,*cellOut;
    k9VobuList vobuList;   //only used for angle blocks
    uchar temp[4096];
    int tempSize;
    uint32_t m_position;
    k9TitleSetList titleSets;
    QString argAudio,argSubp;
    QString argFactor,argSize;
    void prepareVTS(int VTS);
    void playCell (KProcess * _process, int vts_num, int pgc_num, int cell);
    uint32_t copyVobu( KProcess *_process,dvd_file_t  *_fileHandle,uint32_t _startSector,k9Vobu *_vobu);
    void copyCell(int VTS, int pgc,int cell,bool _empty);
    void copyAngleBlock(k9CellCopyList *_list,uint _num);
    void copyEmptyPgc(int _vts,int _pgc,int _cell);
    void updateVob();
    void updateIfo();
    void updateMainIfo();
    uint32_t copyMenu (int _vts);
    k9Vobu * remapVobu(uint32_t *value);
    k9Vobu * remapOffset(uint32_t _sector,uint32_t *offset,int dir);
    k9BackupDlg *backupDlg;
    void clearOutput(QString name);
    QString inject;
    bool error;
    void seterror(const QString &_msg);
    KProcess *createVampsProcess();
};



#endif
