//
// C++ Implementation:
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "k9progress.h"
#include <QProgressBar>
#include <qlabel.h>
#include <qapplication.h>
#include <qeventloop.h>
#include <qimage.h>
#include <qpainter.h>
#include <kstandarddirs.h>
#include <qmovie.h>
#include <qlayout.h>



k9Progress::k9Progress(QWidget* parent)
        : QDialog(parent) {
    Ui_Progress.setupUi(this);
    m_process=new k9Process(this,0);
    m_wimage=new k9DrawImage(Ui_Progress.image);
    QGridLayout *l=new QGridLayout(Ui_Progress.image);
    l->addWidget(m_wimage,0,0);
    Ui_Progress.bCancel->setGuiItem(KStandardGuiItem::Stop);


}


k9Progress::~k9Progress() {
    delete m_process;
}


void k9Progress::setElapsed(const QString _text) {
    Ui_Progress.lblElapsed->setText(_text);
}

void k9Progress::setTitle(const QString _text) {
    Ui_Progress.lblTitle->setText(_text);
}


void k9Progress::setLabelText(const QString _text) {
    Ui_Progress.LabelText->setText(_text);
}

void k9Progress::setProgress(long _position,long _total) {
    Ui_Progress.ProgressBar->setRange(0,_total);
    Ui_Progress.ProgressBar->setValue(_position);
}

int k9Progress::execute() {
    if (! m_process->isRunning()) {
	qDebug() << m_process->debug();
        if (!m_process->start())
            return -1;
    }

//   m_timer.start(200,FALSE);
    show();
    m_canceled=false;
    //the sync method allows to wait for the process end while receiving stdout.
    m_process->sync();

//   m_timer.stop();
    close();
    if (m_canceled)
	return 0;
    else if (m_process->normalExit())
        return 1;
    else
        return -1;
}


void k9Progress::bCancelClick() {
    m_process->kill();
    m_canceled=true;
}

k9Process* k9Progress::getProcess() const {
    return m_process;
}

/*$SPECIALIZATION$*/


void k9Progress::setImage(QString _fileName) {
    m_wimage->setImage(_fileName);
}

void k9Progress::setImage(const QImage &_image) {
    m_wimage->setImage(_image);
}


void k9Progress::setMovie(QString _fileName) {
    m_wimage->hide();
    Ui_Progress.image->setPalette(this->palette());
    QMovie *mv=new QMovie(_fileName);
 //   mv.setBackgroundColor(this->paletteBackgroundColor());
    Ui_Progress.image->setMovie(mv);
    mv->start();
}


bool k9Progress::getCanceled() const {
    return m_canceled;
}
