//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "k9common.h"
#include "k9mp4title.h"
#include "k9config.h"
#include "k9titleencopt.h"
#include "k9dvdtitle.h"
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qstringlist.h>
#include <klocale.h>
#include <qlabel.h>
#include <qframe.h>
#include <qtabwidget.h>
#include <qradiobutton.h>

k9MP4Title::k9MP4Title(QWidget* parent)
: QWidget(parent)
{
    Ui_prefMPEG4.setupUi(this);
    m_titleEncOpt=NULL;
    load();
    Ui_prefMPEG4.ckUseCache->hide();
    Ui_prefMPEG4.tabWidget->setEnabled(false);
    Ui_prefMPEG4.lTitle->setText(i18n("Select a Title in the treeview..."));
 
}

k9MP4Title::~k9MP4Title()
{
}


void k9MP4Title::load() {
    k9Config config;
    
    Ui_prefMPEG4.sbMp4Size->setValue(config.getPrefMp4Size());
    Ui_prefMPEG4.sbMp4Size->setSuffix(" "+ i18n("MB"));
    Ui_prefMPEG4.sbMp4NumberCD->setValue(config.getPrefMp4NumberCD());
    Ui_prefMPEG4.sbAudioGain->setValue(config.getPrefMp4AudioGain());

    
    Ui_prefMPEG4.leMp4Width->setText(config.getPrefMp4Width());
    Ui_prefMPEG4.leMp4Height->setText(config.getPrefMp4Height());

    Ui_prefMPEG4.ckMp4AspectRatio->setChecked(config.getPrefMp4AspectRatio());
    Ui_prefMPEG4.leMp4Height->setEnabled(!Ui_prefMPEG4.ckMp4AspectRatio->isChecked());

    Ui_prefMPEG4.ck2passes->setChecked(config.getPrefMp42Passes());
    Ui_prefMPEG4.ckUseCache->setChecked(config.getPrefUseCellCache());

    Ui_prefMPEG4.leMp4AudioBitrate->setText(config.getPrefMp4AudioBitrate());
    Ui_prefMPEG4.leMp4VideoBitrate->setText(config.getPrefMp4VideoBitrate());

    QStringList m_codecLabels=config.getCodecLabels();
    QStringList m_codecLabelsAudio=config.getCodecLabelsAudio();

    Ui_prefMPEG4.cbMp4Codec->clear();

    Ui_prefMPEG4.cbMp4Codec->addItems(m_codecLabels);
    Ui_prefMPEG4.cbMp4Codec->setCurrentIndex(config.getPrefMp4Codec());

    Ui_prefMPEG4.cbMp4AudioCodec->clear();
    Ui_prefMPEG4.cbMp4AudioCodec->addItems(m_codecLabelsAudio);
    Ui_prefMPEG4.cbMp4AudioCodec->setCurrentIndex(config.getPrefMp4AudioCodec());

    Ui_prefMPEG4.cbMp4AudioCodec->setCurrentIndex(config.getPrefMp4AudioCodec());
    if(config.getPrefMp4VideoBitrate() =="") 
	Ui_prefMPEG4.rbSize->setChecked(true);
    else
	Ui_prefMPEG4.rbBitrate->setChecked(true);
}


/*$SPECIALIZATION$*/
void k9MP4Title::ckMp4AspectRatioClick()
{
  Ui_prefMPEG4.leMp4Height->setEnabled(!Ui_prefMPEG4.ckMp4AspectRatio->isChecked());
   if (m_titleEncOpt)
   	m_titleEncOpt->setKeepAspectRatio(Ui_prefMPEG4.ckMp4AspectRatio->isChecked());

}

void k9MP4Title::selectionChanged(k9DVD *_dvd,bool) {
   if (_dvd==NULL)
	m_titleEncOpt=NULL;
   if (m_titleEncOpt)
   	Ui_prefMPEG4.tabWidget->setEnabled(m_titleEncOpt->getTitle()->isSelected());;


}


void k9MP4Title::titleChanged( k9DVDTitle *_title) {
    if (_title==NULL) {
    	m_titleEncOpt=NULL;
    	Ui_prefMPEG4.tabWidget->setEnabled(false);
    	Ui_prefMPEG4.lTitle->setText(i18n("Select a Title in the treeview..."));
    }
    else {
        Ui_prefMPEG4.lTitle->setText(_title->getname());
    	Ui_prefMPEG4.tabWidget->setEnabled( _title->isSelected());
	m_titleEncOpt=_title->getEncOpt();
	k9TitleEncOpt *opt=m_titleEncOpt;
	Ui_prefMPEG4.sbMp4Size->setValue(opt->getMaxSize());
	Ui_prefMPEG4.sbMp4NumberCD->setValue(opt->getNumParts() );
	Ui_prefMPEG4.sbAudioGain->setValue(opt->getAudioGain() );
	
	Ui_prefMPEG4.leMp4Width->setText(opt->getWidth() );
	Ui_prefMPEG4.leMp4Height->setText(opt->getHeight());
	
	Ui_prefMPEG4.ckMp4AspectRatio->setChecked(opt->getKeepAspectRatio());
	Ui_prefMPEG4.leMp4Height->setEnabled(!Ui_prefMPEG4.ckMp4AspectRatio->isChecked());
	
	Ui_prefMPEG4.ck2passes->setChecked(opt->get2Passes());
        Ui_prefMPEG4.ckUseCache->setChecked(opt->getUseCache());	

	Ui_prefMPEG4.leMp4AudioBitrate->setText(opt->getAudioBr());
	Ui_prefMPEG4.leMp4VideoBitrate->setText(opt->getVideoBr());
	Ui_prefMPEG4.cbMp4Codec->setCurrentIndex(opt->getCodec() );   
        Ui_prefMPEG4.cbMp4AudioCodec->setCurrentIndex(opt->getAudioCodec());

	if(opt->getVideoBr() =="") 
		Ui_prefMPEG4.rbSize->setChecked(true);
	else
		Ui_prefMPEG4.rbBitrate->setChecked(true);
    }
   Ui_prefMPEG4.leMp4VideoBitrate->setEnabled(Ui_prefMPEG4.rbBitrate->isChecked());
   Ui_prefMPEG4.sbMp4Size->setEnabled(Ui_prefMPEG4.rbSize->isChecked());

}


void k9MP4Title::cbMp4CodecActivated( int _value) {
   if (m_titleEncOpt)
   	m_titleEncOpt->setCodec(_value);
}

void k9MP4Title::cbMp4AudioCodecActivated( int _value) {
   if (m_titleEncOpt)
   	m_titleEncOpt->setAudioCodec(_value);
}

void k9MP4Title::ck2passesClicked() {
   if (m_titleEncOpt)
   	m_titleEncOpt->set2Passes(Ui_prefMPEG4.ck2passes->isChecked());
}

void k9MP4Title::ckUseCacheClick() {
   if (m_titleEncOpt)
   	m_titleEncOpt->setUseCache(Ui_prefMPEG4.ckUseCache->isChecked());
}

void k9MP4Title::sbMp4SizeValueChanged( int _value) {
   if (m_titleEncOpt)   
   	m_titleEncOpt->setMaxSize(_value);
}

void k9MP4Title::sbMp4NumberCDValueChanged( int _value ) {
   if (m_titleEncOpt)   	
   	m_titleEncOpt->setNumParts(_value);
}

void k9MP4Title::sbAudioGainValueChanged( int _value ) {
   if (m_titleEncOpt)   	
   	m_titleEncOpt->setAudioGain(_value);
}

void k9MP4Title::leMp4WidthTextChanged( const QString & _value) {
   if (m_titleEncOpt)
	m_titleEncOpt->setWidth(_value);
}

void k9MP4Title::leMp4HeightTextChanged( const QString & _value) {
   if (m_titleEncOpt)
        m_titleEncOpt->setHeight(_value);
}

void k9MP4Title::leMp4AudioBitrateTextChanged( const QString & _value) {
   if (m_titleEncOpt)
	m_titleEncOpt->setAudioBr(_value);
}


void k9MP4Title::leMp4VideoBitrateTextChanged( const QString & _value) {
   if (m_titleEncOpt)
	m_titleEncOpt->setVideoBr(_value);
}


void k9MP4Title::rgVideoSizeChanged(){
   if (Ui_prefMPEG4.rbSize->isChecked()) 
	Ui_prefMPEG4.leMp4VideoBitrate->setText("");
   Ui_prefMPEG4.leMp4VideoBitrate->setEnabled(Ui_prefMPEG4.rbBitrate->isChecked());
   Ui_prefMPEG4.sbMp4Size->setEnabled(Ui_prefMPEG4.rbSize->isChecked());
}

