//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "k9prefdvd.h"
#include "k9config.h"
#include <kstandarddirs.h>
#include <kurlrequester.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <klocale.h>

k9prefDVD::k9prefDVD(QWidget* parent)
: QWidget(parent)
{
    Ui_prefDVD.setupUi(this);
    k9Config config;
    Ui_prefDVD.urOutput->setMode(KFile::Directory);
    Ui_prefDVD.urOutput->setUrl(config.getPrefOutput());
    Ui_prefDVD.ckK3b->setChecked(config.getPrefK3b());

    Ui_prefDVD.ckAutoBurn->setChecked(config.getPrefAutoBurn());
    Ui_prefDVD.ckQuickScan->setChecked(config.getQuickScan());
    Ui_prefDVD.ckDvdAuthor->setChecked(config.getUseDvdAuthor());
    Ui_prefDVD.ckDelTmpFiles->setChecked(config.getPrefDelTmpFiles());
    Ui_prefDVD.ckMpegChapter->setChecked(config.getMpegChapters());
    Ui_prefDVD.sbSize->setValue(config.getPrefSize());
    Ui_prefDVD.sbSize->setSuffix(" "+ i18n("MB"));
}

k9prefDVD::~k9prefDVD()
{
}

/*$SPECIALIZATION$*/

void k9prefDVD::save() {
    k9Config config;
    config.setPrefOutput( Ui_prefDVD.urOutput->url().path());
    config.setPrefK3b(Ui_prefDVD.ckK3b->isChecked());
    config.setPrefAutoBurn( Ui_prefDVD.ckAutoBurn->isChecked());
    config.setPrefSize(Ui_prefDVD.sbSize->value());
    config.setQuickScan( Ui_prefDVD.ckQuickScan->isChecked());
    config.setUseDvdAuthor( Ui_prefDVD.ckDvdAuthor->isChecked());    
    config.setPrefDelTmpFiles(Ui_prefDVD.ckDelTmpFiles->isChecked());
    config.setMpegChapters(Ui_prefDVD.ckMpegChapter->isChecked());
    config.save();
}

