//
// C++ Implementation: k9settings
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "k9settings.h"

#include <qframe.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <qlayout.h>

k9settings::k9settings(QWidget *parent,const QString &caption):  KPageDialog (parent) {
    setFaceType(KPageDialog::List);
    setWindowTitle(KDialog::makeStandardCaption(i18n("Settings"),this));

    //setInitialSize(QSize(750,350), false);


    m_configDlg=new kConfigDlg(this);
    KPageWidgetItem *page = addPage(m_configDlg,i18n("Devices"));
    page->setHeader(i18n("Devices not detected by k9copy"));
    page->setIcon(KIcon("drive-optical"));

    m_prefDVD =new k9prefDVD(this);
    page = addPage(m_prefDVD,i18n("DVD"));
    page->setHeader(i18n("DVD Backup"));
    page->setIcon(KIcon("dvdcopy"));

    m_prefMencoder =new k9prefMencoder(this);
    page = addPage(m_prefMencoder,i18n("MEncoder"));
    page->setHeader(i18n("MPEG-4 Codecs"));
    page->setIcon(KIcon("mencoder"));

    m_prefMPEG4 =new k9prefMPEG4(this);
    page = addPage(m_prefMPEG4,i18n("MPEG-4"));
    page->setHeader(i18n("MPEG-4 Encoding"));
    page->setIcon(KIcon("mp4"));


    m_prefPreview =new k9prefPreview(this);
    page = addPage(m_prefPreview,i18n("Preview"));
    page->setHeader(i18n("Title preview"));
    page->setIcon(KIcon("mplayer"));


    m_prefAuthor = new k9prefAuthor(this);
    page = addPage(m_prefAuthor,i18n("Authoring"));
    page->setHeader(i18n("Authoring"));
    page->setIcon(KIcon("author"));
	
/*
    connect(this, SIGNAL(applyClicked()), SLOT(slotApplyClicked()));
*/
    connect(this, SIGNAL(okClicked()), SLOT(slotOkClicked()));

}

void k9settings::slotOkClicked() {
    m_configDlg->save();
    m_prefDVD->save();
    m_prefMPEG4->save();
    m_prefMencoder->save();
    m_prefPreview->save();
    m_prefAuthor->save();

}

void k9settings::slotApplyClicked() {
   slotOkClicked();
  
//   m_prefMPEG4->load();
}

k9settings::~k9settings() {
 /*   delete m_configDlg;
    delete m_prefDVD;
    delete m_prefMPEG4;
    delete m_prefMencoder;
    delete m_prefPreview;
*/
}
