/***************************************************************************

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************/
/**
   Copyright (C) 2005-2006 by
   Pan Wojtas (Wojtek Sulewski)
   wojteksulewski <at> op.pl
   gg: 2087202
**/

#include "iwait4u.h"

#include "modules/sound/sound.h"
#include "config_dialog.h"
#include "userbox.h"
#include "message_box.h"
#include "config_file.h"
#include "icons_manager.h"

#include "debug.h"

#include "iwait4uGUI.cpp"

Waiting *iwait4u_module;

extern "C" int iwait4u_init()
{
	kdebugf();
	
	iwait4u_module = new Waiting();
	
	kdebugf2();
	return 0;
}

extern "C" void iwait4u_close()
{
	kdebugf();
	
	delete iwait4u_module;

	kdebugf2();
}



Waiting::Waiting()
{
// wczytuje nasz uin
	our_user = userlist->byID("Gadu", config_file.readEntry("General", "UIN"));

// aduje z pliku list osb na ktre czekalimi w ostatniej sesji
	loadTrackedList();
	loadAlwaysTrackedList();

// tworzy GUI
	createGUI();
	
// teraz - po stworzeniu GUI przypisuje PosInMenu jak inn warto, ktrej uywa removeItem i setItemChecked.
	PosInMenu = UserBox::userboxmenu->getItem(tr("Wait for this person"));

// sprawdza, czy kto, na kogo czekamy nie jest dostpny w momencie uruchamiania moduu.
	if (!gadu->status().isOffline())
		checkOnConnection();

// czy wywietlenie popup z metod popupMenu
	connect(UserBox::userboxmenu, SIGNAL(popup()), this, SLOT(popupMenu()));
	connect(userlist, SIGNAL(statusChanged(UserListElement, QString, const UserStatus &, bool, bool)), this, SLOT(userStatusChanged(UserListElement, QString, const UserStatus &, bool, bool)));
}

Waiting::~Waiting()
{
// usuwa GUI
	destroyGUI();

// nie zapisuje list, bo one same si zapisuj w momencie zmiany ;)

	disconnect(UserBox::userboxmenu, SIGNAL(popup()), this, SLOT(popupMenu()));
	disconnect(userlist, SIGNAL(statusChanged(UserListElement, QString, const UserStatus &, bool, bool)), this, SLOT(userStatusChanged(UserListElement, QString, const UserStatus &, bool, bool)));
}

void Waiting::checkOnConnection(void)
{
	kdebugf();
	
	CONST_FOREACH(i, *userlist)
	{
		if(!(*i).usesProtocol("Gadu") || (*i).isAnonymous())
			continue;
		
		if (!(*i).status("Gadu").isOffline())
		{
			if (isOnTrackedList((*i).ID("Gadu")))
			{
				showMessage((*i), tr(" - last time, you have been waiting for this user. Now he is online!"));
				removeFromTrackedList((*i).ID("Gadu"));
			}

			else if (isAlwaysTracked((*i).ID("Gadu")))
				showMessage((*i), tr(" is online!!!"));
		}
	}

	kdebugf2();
}

void Waiting::userStatusChanged(UserListElement user, QString protocolName, const UserStatus &oldStatus, bool massively, bool /*last*/)
{
	kdebugf();
	
	if (isOnTrackedList(user.ID(protocolName)) || isAlwaysTracked(user.ID(protocolName)))
	{
		if (oldStatus.description() != user.status(protocolName).description() && !massively)
			showMessage(user, tr(" has changed his description!"));

		else if (user.status(protocolName).isOnline() || user.status(protocolName).isBusy())
		{
			if (! (config_file.readBoolEntry("Iwait4u", "ignore_busy", false) && (oldStatus.isOnline() || oldStatus.isBusy())))
			{
				if (massively && isOnTrackedList(user.ID(protocolName)))
					showMessage(user, tr(" - last time, you have been waiting for this user. Now he is online!"));
				else
					showMessage(user, tr(" is online!!!"));
			}
		}
		else
			return;		//zapobiega wymazaniu z tracked list w innym wypadku (np. dost -> niedost)

		removeFromTrackedList(user.ID(protocolName));
	}

	kdebugf2();
}

void Waiting::wait4Person(void)
{
	kdebugf();

	UserBox *activeUserBox = UserBox::activeUserBox();
	if (activeUserBox == NULL)
	{
		return;
	}
	UserListElements users = activeUserBox->selectedUsers();
	
	bool remove_all_from_tracked = false;

	FOREACH(i, users)
	{
		if (isOnTrackedList((*i).ID("Gadu")))
		{
			remove_all_from_tracked = true;
			break;			// wystarczy, e znajdzie jednego
		}
	}

	if (remove_all_from_tracked)
	{
		FOREACH(i,users)
				removeFromTrackedList((*i).ID("Gadu"));
	}
	else
	{
		FOREACH(i,users)
			addToTrackedList((*i).ID("Gadu"));
	}

	kdebugf2();
}

void Waiting::showMessage(const UserListElement &user, QString message)
{
	kdebugf();
	
	if (config_file.readBoolEntry("Iwait4u", "make_delay", false))
	{
		QValueList<LastNotify>::iterator i = notifies.begin();
		while (i != notifies.end())
		{
			if ((*i).time.elapsed() > config_file.readNumEntry("Iwait4u", "notify_timeout", 20) * 60 * 1000)
			{
				if ((*i).user == user)
				{
					notifies.remove(i);
					break;
				}
				
				i = notifies.remove(i);
			}
			else if ((*i).user == user)
				return;
			else
				i++;
		}
	}
	

	MessageBox *msg = new MessageBox(QString("<B>%1</B>").arg(user.altNick()) + message, MessageBox::OK, false);
	QString icon = user.status("Gadu").name().remove(" (d.)");		// usuwa description z nazwy statusu
	msg->setIcon(icons_manager->loadIcon(icon));			// aduje ikonk pokazujc, jaki status ma teraz user. name zwraca QString'a
	msg->show();							// nie ma delete, bo okienko samo si zniszczy w momencie nacinicia <OK>

	if (config_file.readBoolEntry("Iwait4u", "use_sounds", false))
	{
		if (config_file.readBoolEntry("Iwait4u", "repeat_sounds", false))
		{
			again_sound = true;
			connect(msg, SIGNAL(okPressed()), this, SLOT(stopPlaingSound()));
			repeatSound();
		}
		else
			sound_manager->play(config_file.readEntry("Iwait4u", "sound_path"), true);
	}
	
	if (config_file.readBoolEntry("Iwait4u", "make_delay", false))
	{
		LastNotify notify;
		notify.time.start();
		notify.user = user;
		
		notifies.append(notify);
	}

	kdebugf2();
}




/**
	tracked
**/


void Waiting::loadTrackedList()
{
	QString loaded_str = config_file.readEntry("Iwait4u", "iwait4u_TrackedList");
	tracked = QStringList::split(",", loaded_str);
}

void Waiting::saveTrackedList()
{
	QStringList list_to_save = tracked;

	config_file.writeEntry("Iwait4u", "iwait4u_TrackedList", list_to_save.join(","));
	config_file.sync();
}

void Waiting::addToTrackedList(const QString id)
{
	tracked.append(id);
	saveTrackedList();
}

void Waiting::removeFromTrackedList(const QString id)
{
	tracked.remove(id);
	saveTrackedList();
}

bool Waiting::isOnTrackedList(QString id)
{
	return tracked.findIndex(id) != -1;		// findIndex zwraca -1, jeli nie znalaz...
}



/**
	ALWAYS tracked
**/


void Waiting::loadAlwaysTrackedList()
{
	QString loaded_str = config_file.readEntry("Iwait4u", "iwait4u_always_trackedList");
	always_tracked = QStringList::split(",", loaded_str);
}

void Waiting::saveAlwaysTrackedList()
{
	QStringList list_to_save = always_tracked;

	config_file.writeEntry("Iwait4u", "iwait4u_always_trackedList", list_to_save.join(","));
	config_file.sync();
}

bool Waiting::isAlwaysTracked(QString id)
{
	return always_tracked.findIndex(id) != -1;		// findIndex zwraca -1, jeli nie znalaz...
}




/**
	sounds
**/


void Waiting::stopPlaingSound(void)
{
	again_sound = false;
}

void Waiting::repeatSound(void)
{
	if (again_sound)
	{
		sound_manager->play(config_file.readEntry("Iwait4u", "sound_path"), true);
		QTimer::singleShot(config_file.readUnsignedNumEntry("Hints", "sounds_delay", 3000), this, SLOT(repeatSound()));
	}
}
