/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FORECAST_CONTAINER_H
#define FORECAST_CONTAINER_H

#include "forecast.h"

#include <qvaluelist.h>

/**
	\class ForecastContener
	Ma za zadanie przechowywa cignite prognozy.
	Prognozy identyfikowane s poprzez kod miejscowoci oraz
	serwer (nazwa pliku konfiguracyjnego). Oznacza to, e w kontenerze
	nie ma dwch prognoz dla tej samej miejscowoci z tym samym serwerem.
	
	Funkcja deleteObsolete() usuwa z pojemnika przestarzae prognozy
**/
class ForecastContainer
{
	QValueList<Forecast> list_;

public:
	const Forecast* getForecast( const QString& configFile, const QString& location );
	void deleteObsolete();
	void add( const Forecast& forecast );
};

#endif // FORECAST_CONTAINER_H
