/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "debug.h"
#include "modules.h"
#include "../sms/sms.h"
#include "ui_handler.h"
#include "smsmiastoplusagateway.h"

miastoplusa_sms::UIHandler uiHandler;

extern "C" int miastoplusa_sms_init()
{
	kdebugf();
	smsConfigurationUiHandler->registerGateway("miastoplusa", &SmsMiastoplusaGateway::isValidMiastoplusa);
	MainConfigurationWindow::registerUiFile(dataPath("kadu/modules/configuration/miastoplusa_sms.ui"), &uiHandler);
	kdebugf2();
	return 0;
}

extern "C" void miastoplusa_sms_close()
{
	kdebugf();
	MainConfigurationWindow::unregisterUiFile(dataPath("kadu/modules/configuration/miastoplusa_sms.ui"), &uiHandler);
	smsConfigurationUiHandler->unregisterGateway("miastoplusa");
	kdebugf2();
}

