/*
 * %kadu copyright begin%
 * Copyright 2010 Bartosz Brachaczek (b.brachaczek@gmail.com)
 * Copyright 2009, 2010 Rafał Malinowski (rafal.przemyslaw.malinowski@gmail.com)
 * %kadu copyright end%
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef STATUS_GROUP
#define STATUS_GROUP

#include <QtCore/QString>

class StatusGroup
{
public:
	enum StatusGroupSortIndex
	{
		StatusGroupSortIndexAfterSetDescription = 101
	};

private:
	QString Name;
	int SortIndex;

public:
	StatusGroup(const QString &name, int sortIndex);

	const QString & name() const { return Name; }

	int sortIndex() const { return SortIndex; }

	bool operator < (const StatusGroup&compare) const;
	bool operator == (const StatusGroup&compare) const;
	bool operator != (const StatusGroup&compare) const;

};

#endif // STATUS_GROUP
