/***************************************************************************
                           fullscreenpanel.cpp
                             -------------------
    begin                : Die Dez 2 2003
    revision             : $Revision: 1.6 $
    last modified        : $Date: 2004/03/29 10:54:03 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ktoolbarbutton.h>
#include <klocale.h>

#include "fullscreenpanel.h"
#include "fullscreenpanel.moc"

FullscreenPanel::FullscreenPanel(QWidget *parent, const char *name ) : QVBox( parent, name, WStyle_Customize | WStyle_NoBorder | WStyle_StaysOnTop | WX11BypassWM )
{
  setMargin( 5 );
  setSizePolicy( QSizePolicy (QSizePolicy::Minimum, QSizePolicy::Minimum) );
  
  toolbar = new KToolBar(this, "toolbar");
  //toolbar->setFixedWidth( 250 );
  toolbar->setIconSize( 16 );

  toolbar->insertButton("player_play", 1, SIGNAL(pressed()), this, SIGNAL(signalPlayPause()), true, i18n("Play/Pause"));
  toolbar->insertButton("player_stop", 2, SIGNAL(pressed()), this, SIGNAL(signalStop()), true, i18n("Stop"));
  toolbar->insertButton("player_start", 3, SIGNAL(pressed()), this, SIGNAL(signalPrevious()), true, i18n("Previous Entry/Chapter"));
  toolbar->insertButton("player_end", 4, SIGNAL(pressed()), this, SIGNAL(signalNext()), true, i18n("Next Entry/Chapter"));
  toolbar->insertButton("player_rew", 5, SIGNAL(pressed()), this, SIGNAL(signalRewind()), true, i18n("Rewind"));
  toolbar->insertButton("player_fwd", 6, SIGNAL(pressed()), this, SIGNAL(signalForward()), true, i18n("Forward"));
  toolbar->insertLineSeparator();
  toolbar->insertButton("view_detailed", 7, SIGNAL(pressed()), this, SIGNAL(signalDVDMenu()), true, i18n("DVD Menu toggle"));
  toolbar->insertButton("folder_sound", 55, true, i18n("Audiochannel"));
  toolbar->insertButton("view_text", 66, true, i18n("Subtitles"));
  toolbar->insertLineSeparator();
  toolbar->insertButton("1uparrow", 8, SIGNAL(pressed()), this, SIGNAL(signalVolUp()), true, i18n("Volume Up"));
  toolbar->insertButton("1downarrow", 9, SIGNAL(pressed()), this, SIGNAL(signalVolDown()), true, i18n("Volume Down"));
  
  title = new QLabel(i18n("<b>Kaffeine Media Player</b>"), this);
  title->setTextFormat( Qt::RichText );
  title->setAlignment( Qt::SingleLine );
  streamInfo = new QLabel(this);
  lengthInfo = new QLabel(this);
  
  connect(&hideTimer, SIGNAL(timeout()), this, SLOT(hide()));
}


FullscreenPanel::~FullscreenPanel() {}


void FullscreenPanel::ShowAt(const QPoint& pos)
{
  move( pos );
  show();
  hideTimer.start( 2500, true );
}


void FullscreenPanel::SetContextMenus( QPopupMenu* audio, QPopupMenu* subtitle )
{
  toolbar->getButton(55)->setPopup( audio, true );
  toolbar->getButton(66)->setPopup( subtitle, true );
}  


void FullscreenPanel::leaveEvent(QEvent*)
{
  widgetToActivate->setActiveWindow();
  hideTimer.start( 2500, true );
}
  

void FullscreenPanel::enterEvent(QEvent*)
{
  setActiveWindow();
  hideTimer.stop();
}  



