/***************************************************************************
                           kaffeine_part.h - kpart for embedded konqueror preview
                             -------------------
    begin                : Don Apr 17 11:30:44 CEST 2003
    revision             : $Revision: 1.16 $
    last modified        : $Date: 2004/05/01 08:05:25 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J.Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef __KaffeinePart_H__
#define __KaffeinePart_H__


#include <kaboutdata.h>
#include <kpushbutton.h>
#include <kparts/part.h>

#include <qslider.h>

#include "playlist.h"
#include "inforow.h"
#include "videowindow.h"
#include "myslider.h"



class KaffeinePart: public KParts::ReadOnlyPart
{
  Q_OBJECT
  public:
    KaffeinePart(QWidget*, const char*, QObject*, const char*, const QStringList&);
    virtual ~KaffeinePart();

    virtual bool closeURL();

    static KAboutData* createAboutData();

  protected:
    virtual bool openFile() {return false; }

  public slots:
    virtual bool openURL(const KURL& url);  

  signals:
    void signalChangePosition(int);
    
  private slots:
    void slotPlay();
    void slotStop();
    void slotNext();
    void slotPrevious();
    void slotPlaybackFinished();
    void slotStartExternal();
    void slotNewTitle(const QString& title);
    void slotSetPosition(int, const QString&);
    void slotNewXineMessage();
    void slotCheckMoved();

  private:
    void Reset();

    VideoWindow* videoWin;
    TextRow* infoRow;
    PlayList* playList;

    MySlider* posSlider;
    KPushButton* timeButton;

    bool stopped;
    QString metaString;

    QTimer posCheckTimer;
    QPoint oldPosition;

    QString visualPlugin;

    QString hrefParam;

    bool autoStart;
    bool imageWindow;
};


#endif
