/***************************************************************************
                           main.cpp
                             -------------------
    begin                : Don Apr 17 11:30:44 CEST 2003
    revision             : $Revision: 1.15 $
    last modified        : $Date: 2004/04/21 11:42:37 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by Jrgen. K.
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kdebug.h>

#include <stdlib.h>

#include "kaffeineapp.h"



static KCmdLineOptions options[] =
{
  { "p", 0, 0 },
  { "play", I18N_NOOP ("Start playing immediately"), 0 },
  { "e", 0, 0 },
  { "enqueue", I18N_NOOP("Append files to the current playlist"), 0},
  { "f", 0, 0 },
  { "fullscreen", I18N_NOOP ("Start in fullscreen mode"), 0 },
  { "m", 0, 0 },
  { "minimal", I18N_NOOP ("Start in minimal mode"), 0 },
  { "a", 0, 0 },
  { "audiodriver <argument>", I18N_NOOP ("Set audiodriver"), "do_nothing" },
  { "x", 0, 0 },
  { "videodriver <argument>", I18N_NOOP ("Set videodriver"), "do_nothing" },
  { "d", 0, 0 },
  { "device <argument>", I18N_NOOP ("Set Audio-CD/VCD/DVD device path."), "do_nothing"},
  { "r", 0, 0 },
  { "rc <argument>", I18N_NOOP ("Remote Control; arguments: play, pause, next, prev, stop, volup, voldown, incpos, decpos, quit"), "do_nothing" },
  { "verbose", I18N_NOOP ("Output xine debug messages"), 0 },
  { "+[file]", I18N_NOOP ("File(s) to play. You can also use plugin names. For example: 'kaffeine VCD'."), 0 },
  { 0, 0, 0 }
};


int main(int argc, char *argv[])
{
  /*
   *  XInitThreads() should always be the first call in multithreaded X programs -
   *  but because of a bug in older xfree versions that can freeze at startup -
   *  for this versions we call XInitThreads() in videowindow.cpp.
   *  This should finaly fix the crash on closing with xfree 4.4.
   *
   *  kpart: We call XInitThreads() in videowindow.cpp - so the part is not stable with xfree 4.4...
   *  The solution would be to add XInitThreads() in main() of konqueror.
   */

#ifdef FamilyInternet6  /* in X.h since xfree version 4.3.99.10 */
  kdDebug(555) << "XInitThreads()" << endl;
  XInitThreads();
#endif  

  KAboutData aboutData( "kaffeine", "Kaffeine",
    VERSION, I18N_NOOP("A xine based media player. Take a look at Kaffeine Handbook for more information."),
    KAboutData::License_GPL,
    "(c) 2003-2004, Jürgen Kofler", 0, "http://kaffeine.sourceforge.net", /*bug reports to:*/ "kaffeine-user@lists.sourceforge.net");

  aboutData.addAuthor("Jürgen Kofler", I18N_NOOP("Original author, Project Admin, Developer"), "kaffeine@gmx.net");
  aboutData.addAuthor("Michael Rolf", I18N_NOOP("Developer, Tester"), "mi.rolf@gmx.net");
  aboutData.addAuthor("Giorgos Gousios", I18N_NOOP("Developer"), "gousiosg@cs.man.ac.uk");

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); 

  if (!KaffeineApp::start()) 
  {
    exit (0);    /* can't start new instance */
  }
  
  KaffeineApp a;
  
  return a.exec();
}


