/***************************************************************************
                           playlist.h
                             -------------------
    begin                : Die Apr 22 2003
    revision             : $Revision: 1.22 $
    last modified        : $Date: 2004/04/19 10:14:40 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYLIST_H
#define PLAYLIST_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kaction.h>
#include <kurl.h>
#include <kpopupmenu.h>
#include <kfileitem.h>
#include <kmainwindow.h>
#include <kdialogbase.h>

#include <qlayout.h>
#include <qptrlist.h>
#include <qstrlist.h>
#include <qpixmap.h>
#include <qlistbox.h>
#include <qvbox.h>

#include <xine.h>

#include "urllistview.h"
//#include "playlistitem.h"

   

class PlayList : public KMainWindow
{
   Q_OBJECT

friend class MyXMLParser;
friend class NoatunXMLParser;

   
public: 
	PlayList(const xine_t* const xine, QWidget*videoWindow, QWidget *parent=0, const char *name=0, bool needGUI = true);
	~PlayList();

 QListViewItem* GetCurrent();  /* get current playlist entry */
 QListViewItem* GetNext();
 QListViewItem* GetPrevious();
 QListViewItem* GetLast();

/* insert a KURL(list) after a specific item */ 
 void Add(const KURL& mrl, QListViewItem* after);
 void Add(const KURL::List& mrls, QListViewItem* after);
/* add autoplay-plugin urls given from xine */ 
 void AddAutoplayUrls(const QStringList& mrls, QListViewItem* after);
 
 void SetEndless(bool e);
 void SetRandomPlay(bool r);
 void SetLastPlaylist(const QString& pl);
 void SetAutoplayList(const QStringList& autoplay) { autoplayList = autoplay; }
 void SetFileFilter(const QString& filter) { fileFilter = filter; }

 const QString& GetMetaInfoString() const { return metaInfoString; }
 const bool GetReadMetaOnLoading() const { return metaOnLoading; }

 const QString& GetLastPlaylist() const;
 void ReloadLastPlaylist();
 void SaveToolbarSettings(KConfig* config);
 void LoadToolbarSettings(KConfig* config);

 const QColor& GetAlternateColor() const { return altCol; }
 KActionCollection* GetActionCollection() const { return actionCollection; }
 
 //helpers
 bool EndsWith(QString, QString, bool);
 bool StartsWith(QString, QString, bool);
 
 signals:
  void signalPlayDirect();
  void signalQuit();
  void signalPlayPause();
  void signalStop();
  void signalAutoplayPlugin(const QString& id, QListViewItem* after);
    
 public slots:
  void slotAddMrl(const QString&);  /* add a mrl sent by xine (as a child item) */
  void slotGetLengthInfo(const QString& time);
  void slotGetStreamInfo(const QString& streamInfo);
  void slotClearList();  /* clear the whole list */
  void slotSetMetaInfoString(const QString&);
  void slotSaveCurrentPlaylist();
  void slotRefreshMetaInfo();
  void slotGetMetaInfo( const QString& metaInfo);
  void slotReadMetaOnLoading( bool read ) { metaOnLoading = read; }
  void slotSetAlternateColor( const QColor& );

 private slots:
  void slotPlayDirect(QListViewItem* item);  /* doubleclick */
  
  void slotDropEvent(QDropEvent*, QListViewItem*);
  void slotAddFiles();
  void slotAddUrl();
  void slotAddDir();
 
  void slotCut();
  void slotPaste();
  void slotCopy();
  void slotRemoveSelected();
  void slotOpenPlaylist();
  void slotSavePlaylist();
  void slotTrySaveCurrentPlaylist();
  void slotFindText(const QString&);

  void slotSortByTitle();
  void slotSort( int );

  void slotExportHtml();
  void slotImportPls();
  void slotImportNoatun();
  void slotImportM3U();
  void slotImportAsx();

  void slotPrint();

  void slotViewToolbar();
  void slotToolbarVisibilityChanged(bool visibility);

  void slotSetVideoWinActive();
  
 protected:
   virtual void closeEvent(QCloseEvent*);  /* catch the quit signal - hide playlist */
    
 private:

  void InitActions();
  void InitMenus();

  QListViewItem* CreateItem(QListViewItem* after, QString url, QString mime = QString::null,
                            QString title = QString::null, QListViewItem* parent = NULL,
                            QString length = QString::null, QString info = QString::null,
                            QStringList subtitles = QStringList());

  bool LoadPlaylist(const QString&, QListViewItem*);
  bool LoadNoatunPlaylist(const QString&, QListViewItem*);
  bool LoadM3UPlaylist(const QString&, QListViewItem*);
  bool LoadPlsPlaylist(const QString&, QListViewItem*);
  bool LoadAsxPlaylist(const QString&, QListViewItem*);
  bool LoadRamPlaylist(const KURL&, QListViewItem*);

  bool SavePlaylist(const QString&);

  void SetCurrentEntry(QListViewItem*);

  void GetMetaInfo( const QString& url, const QString& mimeName, QString& title, QString& length );
  void GetMetaFromXine( const QString& url, QString& title, QString& length );

  void UpdateStatusBar();

  QWidget* videoWin;
  QColor altCol;

  uint playTime;
  uint playTimeVisible;
  uint countVisible;

  bool searchSelection;
  
  bool withGUI;
  bool metaOnLoading;

  bool sortAscending;
  
  xine_t* xineEngine;
  QString lastPlaylist;
 
  UrlListView* list;
  QListViewItem* currentEntry;
  QListViewItem* currentChild;

  QString fileFilter;
  QString metaInfoString;
  QStringList autoplayList;

  void CreateRandomList();
  QPtrList<QListViewItem> randomList;
  int currentRandomListEntry;

  QPixmap isCurrentEntry;
  QPixmap infoPixmap;
  QPixmap cdPixmap;
  QPixmap bookmarkPixmap;
   
  bool endless;
  bool random;

  KPopupMenu* fileMenu;
  KPopupMenu* addMenu;
  KPopupMenu* editMenu;
  KPopupMenu* importMenu;
  KPopupMenu* exportMenu;
  KPopupMenu* viewMenu;

  KActionCollection* actionCollection;

  KAction* fileNew;
  KAction* fileSavePlaylist;
  KAction* fileSavePlaylistAs;
  KAction* fileOpenPlaylist;
  KAction* fileExportHtml;
  KAction* fileImportPls;
  KAction* fileImportNoatun;
  KAction* fileImportM3U;
  KAction* fileImportAsx;
  KAction* filePrint;
  KAction* fileClose;
  KAction* fileQuit;

  KAction* addFiles;
  KAction* addUrl;
  KAction* addDir;
  KAction* addPaste;

  KAction* editSort;  
  KAction* editCut;
  KAction* editCopy;
  KAction* editPaste;

  KToggleAction* viewToolbar;
    
};

class SubtitleChooser : public KDialogBase
{
  Q_OBJECT
public:
  SubtitleChooser(QStringList, QString, QWidget *parent=0, const char *name = 0);
  virtual ~SubtitleChooser();
  
  QString getSelection();

private:
  QListBox *table;
};

#endif
