/***************************************************************************
                           xineconfig.h - config dialog for xine parameters
                             -------------------
    begin                : Son Mai 4 2003
    revision             : $Revision: 1.4 $
    last modified        : $Date: 2004/01/11 12:41:17 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by Jrgen. K.
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XINECONFIG_H
#define XINECONFIG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <klineedit.h>
#include <kcombobox.h>
#include <kdialogbase.h>

#include <qwidget.h>
#include <qhbox.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qvbox.h>
#include <qptrlist.h>
#include <qlayout.h>
#include <qstringlist.h>


#include <xine.h>

/* stores a single config entry of the config file */
class XineConfigEntry : public QHBox
{
  Q_OBJECT
public:
  XineConfigEntry(QWidget* parent, QGridLayout* grid, int row, xine_cfg_entry_t* entry);
  ~XineConfigEntry();

  bool ValueChanged() const;  /* was the value changed by user? */
  const QString& GetKey() const; /* the key (name) of the entry */
  int GetNumValue() const;
  const QString& GetStringValue() const;
  void SetValueUnchanged() { valueChanged = false; }
  
private slots:
   void slotNumChanged(int);
   void slotBoolChanged(bool);
   void slotStringChanged(const QString&);  

private:  
  bool valueChanged;
  QString key;
  int numValue;
  QString stringValue;

  KLineEdit* stringEdit;
  KComboBox* enumEdit;
  QSpinBox* numEdit;
  QCheckBox* boolEdit;
};

  
class XineConfig : public KDialogBase  {
   Q_OBJECT
public: 
  XineConfig(const xine_t* const xine);
  ~XineConfig();

private slots:
   void slotOkPressed();
   void slotApplyPressed();
  

private:

  QPtrList<XineConfigEntry> entrys;

  xine_t* xineEngine;


};

#endif


