# Find BluetoothTools
# ~~~~~~~~~~~~~~~~~~~
# Copyright (C) 2009, Richard A. Johnson <rjohnson@kde.org>
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#
# BlueZ website: http://www.bluez.org
#
# Find the installed version of BlueZ (ie. the tools, such as hciconfig)

FIND_FILE(BLUETOOTHTOOLS hciconfig PATHS /sbin /bin /usr/sbin /usr/bin)

IF(BLUETOOTHTOOLS)
    SET(BLUETOOTHTOOLS_FOUND TRUE)
ENDIF(BLUETOOTHTOOLS)

IF(BLUETOOTHTOOLS_FOUND)
    IF(NOT BLUETOOTHTOOLS_FIND_QUIETLY)
	MESSAGE(STATUS "Found Bluetooth Tools: ${BLUETOOTHTOOLS}")
    ENDIF(NOT BLUETOOTHTOOLS_FIND_QUIETLY)
ELSE (BLUETOOTHTOOLS_FOUND)
    IF(BLUETOOTHTOOLS_FIND_REQUIRED)
	MESSAGE(FATAL_ERROR "Could not find bluetooth-tools")
    ENDIF(BLUETOOTHTOOLS_FIND_REQUIRED)
ENDIF(BLUETOOTHTOOLS_FOUND)
