# Find WirelessTools
# ~~~~~~~~~~~~~~~~~~~
# Copyright (C) 2009, Richard A. Johnson <rjohnson@kde.org>
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#
# Wireless Tools website: http://www.hpl.hp.com/personal/Jean_Tourrilhes/Linux/Tools.html
#
# Find the installed version of Wireless Tools (ie. the tools, such as iwconfig)

FIND_FILE(WIRELESSTOOLS iwconfig PATHS /sbin /bin /usr/sbin /usr/bin)

IF(WIRELESSTOOLS)
    SET(WIRELESSTOOLS_FOUND TRUE)
ENDIF(WIRELESSTOOLS)

IF(WIRELESSTOOLS_FOUND)
    IF(NOT WIRELESSTOOLS_FIND_QUIETLY)
	MESSAGE(STATUS "Found Wireless Tools: ${WIRELESSTOOLS}")
    ENDIF(NOT WIRELESSTOOLS_FIND_QUIETLY)
ELSE (WIRELESSTOOLS_FOUND)
    IF(WIRELESSTOOLS_FIND_REQUIRED)
	MESSAGE(FATAL_ERROR "Could not find wireless-tools")
    ENDIF(WIRELESSTOOLS_FIND_REQUIRED)
ENDIF(WIRELESSTOOLS_FOUND)
