/*
    firsttimewizard.cpp - Kamefu first-time wizard.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "firsttimewizard.h"

#include <qlayout.h>
#include <qvbox.h>

#include "firsttimewizardpage1.h"
#include "firsttimewizardpage2.h"
#include "firsttimewizardpage3.h"

#include <klocale.h>
#include <kiconloader.h>

#include <kamefupreferences.h>

FirstTimeWizard::FirstTimeWizard(QWidget *parent, const char *name)
 : KDialogBase( KDialogBase::IconList, i18n("First Time Wizard"), KDialogBase::User1 | KDialogBase::Cancel, KDialogBase::User1, 
	parent, name, false, true, KGuiItem(i18n("Finish"), SmallIconSet("apply")) )
{
	QVBox *page1 = addVBoxPage( i18n("Welcome"), i18n("Welcome to Kamefu"), SmallIcon("wizard") );
	new FirstTimeWizardPage1(page1, "page1");
	
	QVBox *page2VBox = addVBoxPage( i18n("Directories"), i18n("Select collection directories"), SmallIcon("folder") );
	// Create into a object, because it will be reused later.
	page2 = new FirstTimeWizardPage2(page2VBox, "page2");

	QVBox *page3 = addVBoxPage( i18n("Finish"), i18n("Congratulations!"), SmallIcon("apply") );
	new FirstTimeWizardPage3(page3, "page3");

	connect(this, SIGNAL(user1Clicked()), this, SLOT(accept()));
	connect(this, SIGNAL(aboutToShowPage(QWidget *)), this, SLOT(slotAboutToShowPage(QWidget *)));

	// Disable Finish button.
	enableButton( KDialogBase::User1, false );
}


FirstTimeWizard::~FirstTimeWizard()
{
	delete page2;
}

void FirstTimeWizard::accept()
{
	// Save settings before calling base accept().
	// Accept calls collection building and it need the selected directories.
	KamefuPreferences::self()->setCollectionRecursive(page2->recursiveSelected());
	KamefuPreferences::self()->setCollectionDirectories(page2->directoriesSelected());
	KamefuPreferences::self()->writeConfig();

	emit accepted();

	KDialogBase::accept();
}

void FirstTimeWizard::reject()
{
	KDialogBase::reject();
}

void FirstTimeWizard::slotAboutToShowPage(QWidget *page)
{
	// Only enable the finish button when it's the page3.
	FirstTimeWizardPage3 *page3 = dynamic_cast<FirstTimeWizardPage3*>(page->child("page3"));
	if(page3)
	{
		enableButton( KDialogBase::User1, true );
	}
	else
	{
		enableButton( KDialogBase::User1, false );
	}
}

#include "firsttimewizard.moc"
