
/*
 * Kanatest
 *
 * Copyright (C) 2001-2004, 2006 Tomasz Mka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <gtk/gtk.h>
#include <config.h>
#include <locale.h>

#include "gui.h"
#include "prefs.h"
#include "stats.h"
#include "i18n.h"


int main (int argc, char **argv)
{
 
    prefs_read_config ();
    stats_read_list ();

    gtk_init (&argc, &argv);

#if ENABLE_NLS
    gtk_set_locale();
    bindtextdomain(PACKAGE, LOCALEDIR);
    textdomain(PACKAGE);
#endif

    gui_create_window ();
    gtk_main ();

    stats_write_list ();
    prefs_write_config ();

    return 0;
}


