/***************************************************************************
                          ccheckfiles.h  -  description
                             -------------------
    begin                : mar jan 20 2004
    copyright            : (C) 2004 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCHECKFILES_H
#define CCHECKFILES_H

#include <qdialog.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <klistview.h>

/**Check if the files to be extracted already exist on the disk
  *@author Eric Coquelle
  */

class CCheckFiles : public QDialog  {
  Q_OBJECT
public: 
	CCheckFiles();
	~CCheckFiles();
 /** Check if file will overwrite a file on the disk (the extract directory must be provided
      * first with setExtractPath). Then  fills the listboxes */
  void addFile(QStringList);
  void addFile(QString& name, int& size, QDateTime& date);
  void addFile(QString);
  /** returns the files that can be extracted */
  QStringList getFiles();
  /** Set the path where the files will be extracted */
  void setExtractPath(QString);
  /** return true if all the files can be extracted without any user action */
  bool canSafelyExtract();
  /**Shall we always overwrite files ?*/
  static void setOverwrite(bool);
  
private: // Private methods
  /** return true if the present file can be safely extracted, e.g. it will neither overwrite a file nor goes to an unwritable directory */
  bool checkSafelyExtract(QString&, unsigned int size=0, QDateTime date=QDateTime::currentDateTime());
  /** Check if the extract path exists. Otherwise, create it if possible */
  bool checkExtractPath(QString);

private:
  KListView *files;
  QPushButton *ok;
  QString extractpath;
  QStringList filescanbeextracted;
  QStringList filescannotbeextracted;
  QStringList filesaskbeforeextract;
  bool canwritebasepath;
  static bool overwrite;
};

#endif
