/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kiconloader.h>

#include <qpixmap.h>
#include <qfont.h>
#include <qlayout.h>
#include <qlabel.h>

#include "cwizardstep1patch.h"


CWizardStep1Patch::CWizardStep1Patch(QWidget *parent, const char *name) : QDialog(parent,name,true){
  initDialog();
  buttonNext->setFocus();

  connect(buttonPrevious, SIGNAL(clicked()), SLOT(reject()));
  connect(buttonNext, SIGNAL(clicked()), SLOT(accept()));	
}

CWizardStep1Patch::~CWizardStep1Patch(){
}

void  CWizardStep1Patch::initDialog()
{
  QGridLayout* layout=new QGridLayout(this, 8, 4, 12);
  this->setCaption(i18n("Installation wizard step 2"));

  QLabel* labelwizard1p= new QLabel(this,"NoName");
  labelwizard1p->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(labelwizard1p, 0, 6, 0, 1);

  QLabel* QLabel_2= new QLabel(this,"NoName");
  QLabel_2->setFont(QFont("utopia", 16, 75,true));
  QLabel_2->setText(i18n("Apply a patch"));
  layout->addMultiCellWidget(QLabel_2, 0, 0, 2, 3);

  layout->addRowSpacing(1, 8);

  QLabel* QLabel_3= new QLabel(this,"NoName");
  QLabel_3->setText(i18n("A patch is a text file that applies some modifications to files (e.g. the patches of the Linux kernel). You will be prompted to select the folder containing the software to be patched (e.g. ~/karchiver)"));
  QLabel_3->setAlignment(Qt::WordBreak | Qt::AlignJustify | Qt::ExpandTabs);
  layout->addMultiCellWidget(QLabel_3, 2, 6, 2, 3);

  buttonPrevious= new QPushButton(this,"buttonPrevious");
  buttonPrevious->setText(i18n("<< &Previous"));
  layout->addWidget(buttonPrevious, 7, 2);

  buttonNext= new QPushButton(this,"buttonNext");
  buttonNext->setText(i18n("&Next >>"));
  layout->addWidget(buttonNext, 7, 3);

}

#include "cwizardstep1patch.moc"

