/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : DATE
    copyright            : (C) YEAR by AUTHOR
    email                : EMAIL
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cwizardstep3.h"
#include <kdebug.h>
#include <qdir.h>
#include <qfileinfo.h>

CWizardStep3::CWizardStep3(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();

	/*aditional init*/
	setCaption(i18n("KArchiver wizard's last step"));


  initLeds();

	connect(&processpath, SIGNAL(receivedStdout (KProcess*, char*, int)), this, SLOT(gotStdout(KProcess*, char*, int)));
	connect(&processpath, SIGNAL(processExited(KProcess*)), this, SLOT(endProcess(KProcess*)));
	connect(&processpath, SIGNAL(receivedStderr (KProcess*, char*, int)), this, SLOT(gotStderr(KProcess*, char*, int)));

	connect(&processinst, SIGNAL(receivedStdout (KProcess*, char*, int)), this, SLOT(gotStdout(KProcess*, char*, int)));
	connect(&processinst, SIGNAL(receivedStderr (KProcess*, char*, int)), this, SLOT(gotStderr(KProcess*, char*, int)));
	connect(&processinst, SIGNAL(processExited(KProcess*)), this, SLOT(endProcessInst(KProcess*)));

	connect(buttonStart, SIGNAL(clicked()), this, SLOT(slotdetermineTypeOperation()));

	connect(buttonCancel, SIGNAL(clicked()), this, SLOT(accept()));

	makeinstall="";
	operation=-1;
}

CWizardStep3::~CWizardStep3(){
}

/** Recieve Stdout from the running process */
void CWizardStep3::gotStdout(KProcess *, char *buffer, int buflen)
{
	QString str=buffer;
	str.truncate(buflen-1);
  if(operation==CONFIGURATION)
    mleOutput->setColor(Qt::blue);
  else
    mleOutput->setColor(Qt::black);
  
	mleOutput->append(str);
}

/** Recieve Stderr from the running process */
void CWizardStep3::gotStderr(KProcess *proc, char *buffer, int buflen)
{
	QString str=buffer;
	str.truncate(buflen-1);
  mleOutput->setColor(Qt::red);
	mleOutput->append(str);
  if(proc==&processpath)
    led3->setColor(Qt::yellow);
  else
  {
    switch(operation)
    {
      case CONFIGURATION:
        led1->setColor(Qt::yellow);
        break;
      case COMPILATION:
        led2->setColor(Qt::yellow);
        break;
      default:
        led3->setColor(Qt::yellow);
        break;
    }
  }  
}

/** End of the process */
void CWizardStep3::endProcess(KProcess* )
{
	led3->setState(KLed::On);
}

/** End of the process */
void CWizardStep3::endProcessInst(KProcess*)
{
      QString str;
      if(operation==CONFIGURATION)
      {
              operation=COMPILATION;
              led1->setState(KLed::On);
              processinst.clearArguments();
              processinst << make;
              str="-C";
              str+=basedir;
              processinst << str;
              if(processinst.start(KProcess::NotifyOnExit,KProcess::AllOutput)==false)
                kdDebug()<<("Pb process\n");
      }
      else if(operation==COMPILATION)
      {
              operation=INSTALLATION;
              led2->setState(KLed::On);
              if(typeInstallation==2)
              {
                      //Don't install
                      led3->setState(KLed::On);
                      buttonStart->setEnabled(false);
                      buttonCancel->setText(i18n("Finish"));
                      operation=-1;
              }
              else if((operation==INSTALLATION)&&(KMessageBox::warningContinueCancel(this,
                                                                                                                                                                      i18n("Compilation is now complete\nCheck the output NOW for errors\nDo you still want to install as root?"),
                                                                                                                                                                      i18n("Warning"),
                                                                                                                                                                      i18n("Continue"))==KMessageBox::Continue))
              {
                      operation=FININSTALL;
                      processinst.clearArguments();

                      if(typeInstallation==0)
                      {
                              processinst << "kdesu";
                              processinst << "-c";
                              processinst << "\"";
                      }
                      processinst << make;
                      str="-C";
                      str+=basedir;
                      processinst << str;
                      processinst << makeinstall;
                      if(typeInstallation==0)
                      {
                              processinst << ";";
                              processinst << "echo";
                              processinst << "Installation achieved, closing in progress...";
                              processinst << ";";
                              processinst << "sleep";
                              processinst << "4";
                              processinst << "\"";
                      }
                      if(processinst.start(KProcess::NotifyOnExit,KProcess::Stdout)==false)
                        kdDebug()<<("Pb process\n");
              }
      }
      else if(operation==FININSTALL)
      {
        led3->setState(KLed::On);
        buttonStart->setEnabled(false);
        buttonCancel->setText(i18n("Finish"));
      }
}

/** Let's start patching ! */
void CWizardStep3::doPatch()
{
	QDir rep;
	initLeds();

	reppatch=KFileDialog::getExistingDirectory(QDir::homeDirPath(),0,i18n("Choose the folder to patch"));

	rep=reppatch;
	if(!rep.isReadable())
	{
		led1->setColor(KLed::red);
		led1->setState(KLed::On);
		return;
  }

	if(!rep.cdUp())
	{
		led1->setColor(KLed::red);
		led1->setState(KLed::On);
		return;
	}

	reppatch=rep.path();
	led1->setState(KLed::On);
	basedir+=fichselect;

	processpath.clearArguments();
	processpath << "patch";
	processpath <<"-p0";
	processpath << "-d";
	processpath << reppatch;
	processpath << "-i";
	processpath << basedir;

	if(processpath.start(KProcess::NotifyOnExit,KProcess::AllOutput)==false)
	  kdDebug()<<("Pb process\n");
	led2->setState(KLed::On);
}

void CWizardStep3::setOperation(int op)
{
	typeoperation=op;
}

/* Start the compilation and installation */
void CWizardStep3::doInstall()
{
	QString path_configure;
  int i=0;
  int j=0;
  
  initLeds();

	// Set the path of configure script
	path_configure=basedir+"/";
	path_configure+=config;
 QFileInfo file(path_configure);
 
 kdDebug()<<QString("Looking for %2 script in %1").arg(file.dirPath()).arg(file.baseName())<<endl;
 
 QString baseCompilePath=findFiles(file.dirPath(), file.baseName());
 if( baseCompilePath.isNull() )
 {
    KMessageBox::error(this, i18n("Cannot find the script")+" "+file.baseName());
    accept();
    return;
 }
 else
 {
  basedir=QFileInfo(baseCompilePath).dirPath();
  path_configure=baseCompilePath;//dir+"/"+file.baseName();
 }
 kdDebug()<<QString("Basedir=%1, configure=%2").arg(basedir).arg(path_configure)<<endl;
  if(!configopt.isEmpty())
  {
    while((i=configopt.find(" -",i)+1)!=0)
    {
      processinst << configopt.mid(j,i-1);
      j=i;
    }
    processinst << configopt.mid(j,configopt.length());
  }
	operation=CONFIGURATION;
	processinst.clearArguments();
	processinst << "cd";
	processinst << basedir; 
	processinst << ";";
	processinst << path_configure;
  
	processinst << configopt;
	if(processinst.start(KProcess::NotifyOnExit,KProcess::AllOutput)==false)
	  kdDebug()<<("Pb process conf\n");
}

/** recurse and find @param name ,  contained in the directory @param d */
QString CWizardStep3::findFiles(QDir d, QString name)
{
  QString filewithfulpath=NULL;
  QStringList filesandsubdirs;
  QString basedir=d.path()+"/";
  filesandsubdirs=d.entryList(QDir::Dirs);
  
  for ( QStringList::Iterator it = filesandsubdirs.begin(); it != filesandsubdirs.end(); ++it ) {
    if((*it!=".")&&(*it!=".."))
      filewithfulpath=findFiles(QDir(basedir + *it), name);
  }
  filesandsubdirs=d.entryList(QDir::Files);
  for ( QStringList::Iterator it = filesandsubdirs.begin(); it != filesandsubdirs.end(); ++it ) {
    if( *it == name )
    {
      kdDebug()<<QString("Got %1 vs %2, basedir=%3").arg(*it).arg(name).arg(basedir)<<endl;    
      return(basedir + *it);
    }
  }
  return filewithfulpath;
}

/** Set various parameters for installation */
void CWizardStep3::setParametres(const char* conf, const char* confopt, const char* mak, const char* makinst, int typeInstall){
	config=conf;
	configopt=confopt;
	make=mak;
	makeinstall=makinst;
	typeInstallation=typeInstall;
}

/** Set all leds to green, state=off */
void CWizardStep3::initLeds()
{
	led1->setState(KLed::Off);
	led1->setColor(KLed::green);
	led2->setState(KLed::Off);
	led2->setColor(KLed::green);
	led3->setState(KLed::Off);
	led3->setColor(KLed::green);
}

/** Choose if we'll do a patch (op==0) or an install */
void CWizardStep3::slotdetermineTypeOperation()
{
	if(typeoperation==0)
		doPatch();
	else
		doInstall();
}
#include "cwizardstep3.moc"
