"""A script to generate the code to handle a database from
a configuration script

This script is a Python script which must define at least 2 variables :
- name   : the name of the database
- fields : a list of strings of the form "name:type" where name is the
           name of the field and type, its type
           Example : fields = ['name:str','author:str','issued:datetime.date']

Additional variables can be defined :
- dbmodule       : the database module. Defaults to kirbybase. The module must 
                   be imported in the configuration file
                   Example :
                      import gadfly
                      dbmodule = gadfly
- data_directory : the directory where database will be stored (defaults to 
                   the same directory as the configuration script)
- pageTitle      : the title printed on top of the HTML pages (defaults to
                   the variable name)
- stylesheet     : the stylesheet url applied to all HTML pages (defaults to
                   default.css in this directory)
- security       : the security level. 3 possible values :
                   'low' : anyone can edit and remove records
                   'standard' : only logged in users can manage the base, only
                   the administrator can manage the users' base
                   'high' : only the administrator can manage the base
                   Default is 'low'
"""

import os
import tkFileDialog
import cStringIO
import datetime
import sys
import md5

from HTMLTags import *
from recordsKB_parts import *
import db_specifics

def index():
    # select the configuration file
    print '<FORM ENCTYPE="multipart/form-data" ACTION="../makeScript1.py" method="POST">'
    print "Select the configuration script"
    print INPUT(name="configFile",Type="file")
    print INPUT(Type="submit",value="Ok")
    print '</FORM>'

