"""Karrigell script for managing the database books_sqlite
Generated 06-06-2005 16:37:34
"""
import os
from HTMLTags import *
import md5

# database-specific modules
from pysqlite2 import dbapi2 as sqlite

def makeDict(res):
    # convert the result of a cursor.fetchall() to a list
    # of dictionaries
    records = []
    for item in res:
        records.append(dict([(fname,item[i])
            for (i,fname) in enumerate(['recno', 'title', 'year', 'author'])]))
        for (fn,ft) in zip(field_names,field_types):
            if ft == 'text':
                records[-1][fn] = records[-1][fn].encode('latin-1')
    return records

#parameters
name = "books_sqlite"
pageTitle = "Managing base books_sqlite"
field_names = ['title', 'year', 'author']
field_types = ['text', 'integer', 'text']
connection = sqlite.connect(r'C:\Karrigell\Karrigell-2.1.5\instant_site\books_sqlite')
cursor = connection.cursor()
cursor.execute("SELECT name FROM sqlite_master WHERE type='table'")
if not len(cursor.fetchall()):
    cursor.execute('CREATE TABLE books_sqlite (recno INTEGER PRIMARY KEY, title text, year integer, author text)')

#header
header=HEAD(LINK(rel="stylesheet",href="../default.css") +
    TITLE(pageTitle))

def index():
    user_test = True # default
    print '<html>\n'
    print header
    print H1(pageTitle)
    cursor.execute('SELECT recno,title,year,author FROM books_sqlite')
    records = makeDict(cursor.fetchall())

    if records:
        print '<table class="main" cellpadding="3" cellspacing="0">'
        print '<tr>'
        print Sum([TH(f) for f in field_names])
        if user_test:
            print TH('&nbsp;')*2
        print '</tr>\n'
        counter = 0
        for record in records:
            counter+=1
            if counter % 2:
                print '<tr class="even">'
            else:
                print '<tr class="odd">'
            print TD(record["title"])
            print TD(record["year"])
            print TD(record["author"])
            if user_test:
                print TD(A('Remove',
                    href="removeRecord?recordId=%s" %record['recno']),
                    Class="main")
                print TD(A('Edit',
                    href="editRecord?recordId=%s" %record['recno']),
                    Class="main")
            print '</tr>'
        print '</table>'
    else:
        print "Empty base"

    if user_test:
        print '<p><a href="editRecord?recordId=-1">New record</a>'
    print '</body>\n</html>'

def editRecord(recordId):
    recordId=int(recordId)
    if recordId>-1:
        cursor.execute('SELECT recno,title,year,author FROM books_sqlite WHERE recno = %s'
               %recordId)
        record = makeDict(cursor.fetchall())[0]

        print header
        print H1("Editing a record")
    else:
        print header
        print H1("New record")
        record=dict([(f,'') for f in ['title', 'year', 'author']])
    
    print '<form action="insertRecord" method="post">'

    print INPUT(type="hidden",name="recordId",value=recordId)
    print '<table>'
    print TR(TD("title")+TD(INPUT(name="title",size="40",value=record["title"])))
    print TR(TD("year")+TD(INPUT(name="year",size="40",value=record["year"])))
    print TR(TD("author")+TD(INPUT(name="author",size="40",value=record["author"])))
    print '</table>'
    print INPUT(type="submit",value="Ok")
    print '</form>'
    print '</body>\n</html>'

def insertRecord(recordId,**untyped_fields):

    recordId=int(recordId)
    for (fn,ft) in zip(field_names,field_types):
        if ft == 'text':
            untyped_fields[fn] = unicode(untyped_fields[fn],'latin-1')
    if recordId==-1:
        sql = 'INSERT INTO books_sqlite (recno,title,year,author) VALUES (%s)' \
            %','.join(['NULL']+["'%s'" %untyped_fields[f] for f in field_names])
        cursor.execute(sql)
    else:
        vals = ','.join(["%s = '%s'" %(k,v) for (k,v) in untyped_fields.items()])
        sql = 'UPDATE books_sqlite SET %s WHERE recno = %s' %(vals,recordId)
        cursor.execute(sql)
    connection.commit()
    
    raise HTTP_REDIRECTION,"index"

def removeRecord(recordId):

    sql = 'DELETE FROM books_sqlite WHERE recno = %s' %recordId
    cursor.execute(sql)
    connection.commit()
    raise HTTP_REDIRECTION,"index"

def login():
    print H1("Login")
    print '<form action="check_login" method="post">'
    print TABLE(
        TR(TD("Login")+TD(INPUT(name="login"))) +
        TR(TD("Password")+
            TD(INPUT(name="password", Type="password"))) +
        TR(TD(INPUT(Type="submit",value="Ok"))+
            TD("&nbsp;"))
        )
    print '</form>'

def check_login(**user_data):

    if users_cursor is not None:
        sql = "SELECT recno,login,password FROM books_sqlite_users"
        sql += " WHERE login = '%s' AND password = '%s'" \
            %(user_data['login'],user_data['password'])
        users_cursor.execute(sql)
        user_record = users_cursor.fetchall()
        if user_record:
            user_record = dict(zip(['recno','login','password'],user_record[0]))
    else:
        user_record = None

    if not user_record:
        print "Unknown user"
        print P(A("Back",href="index"))
    else:
        setattr(Session(),'%s_user' %name, user_record['recno'])
        raise HTTP_REDIRECTION,'index'

def logout():
    Session().close()
    raise HTTP_REDIRECTION,'index'
    
def error(msg):
    print header
    print H1(pageTitle)
    print msg
    print P(A('Back',href='index'))
