/*
 * cups.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __CUPS_HH__
#define __CUPS_HH__

#include <string>
#include <vector>
#include <cups/cups.h>

class CupsOption {
public:
  std::string name, value;
};

class CupsSize {
public:
  std::string name, id;
  float width, length, left, bottom, right, top;
};

class CupsCustom {
public:
  std::string name, id;
  float min1, min2;
  float max1, max2;
  float margin1, margin2, margin3, margin4;
};

class CupsPrinter {
public:
  std::string name, instance;
  std::string state;
  bool is_default;
  std::vector<CupsOption>options;
  std::vector<CupsSize>sizes;
  std::string default_paper;
  bool can_custom;
  CupsCustom custom;
};

class Cups {
public:
  Cups();
  ~Cups();
  std::vector<std::string> get_all();
  std::string get_default();
  std::string get_default(int x) { return printers[x].default_paper; }
  bool has_default() { return _has_default; }
  bool is_empty() { return printers.size() == 0 ? true : false; }
  std::vector<std::string> sizes(unsigned);
  int get_height(int pr, int pa) { return static_cast<int>(printers[pr].sizes[pa].length); }
  int get_width(int pr, int pa) { return static_cast<int>(printers[pr].sizes[pa].width); }
  bool print(std::string&, std::string&);
  int get_top(int n, int s) { return static_cast<int>(printers[n].sizes[s].length - printers[n].sizes[s].top); }
  int get_left(int n, int s) { return static_cast<int>(printers[n].sizes[s].left); }
  int get_bottom(int n, int s) { return static_cast<int>(printers[n].sizes[s].bottom); }
  int get_right(int n, int s) { return static_cast<int>(printers[n].sizes[s].width - printers[n].sizes[s].right); }
  std::string& get_status(int n) { return printers[n].state; }
  void set_printer(int n) { printer = n; }
private:
  void set_status(CupsPrinter&);
  bool _has_default;
  CupsPrinter *_default;
  std::vector<CupsPrinter> printers;
  http_t *http;
  int printer;
};

#endif /* __CUPS_HH__ */
