/*
 * filedialog.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __FILEDIALOG_HH__
#define __FILEDIALOG_HH__

#include <gtkmm/filechooserdialog.h>
#include <gtkmm/label.h>
#include <gtkmm/comboboxtext.h>
#include "encodings.hh"
#include "conf.hh"

#define FILE_OPEN Gtk::FILE_CHOOSER_ACTION_OPEN
#define FILE_SAVE Gtk::FILE_CHOOSER_ACTION_SAVE

class FileDialog : public Gtk::FileChooserDialog {
public:
  FileDialog(std::string&, Gtk::FileChooserAction, int, Conf&, Encodings&);
  ~FileDialog();
  int encoding();
  bool run();
  std::vector<std::string> get();
private:
  Gtk::Label label;
  Gtk::HBox box;
  Gtk::ComboBoxText cbox;
  Encodings& _encodings;
  //  std::string file;
};

class SimpleFileDialog : public Gtk::FileChooserDialog {
public:
  SimpleFileDialog(std::string&, Gtk::FileChooserAction, Conf&);
  ~SimpleFileDialog();
  bool run();
  std::string get();
};

#endif /* __FILEDIALOG_HH__ */
