/*
 * pipe.cc
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <unistd.h>
#include <cerrno>
#include "pipe.hh"
#include <sys/types.h>
#include <sys/wait.h>
#include "macros.h"

Pipe::Pipe()
{

}

Pipe::~Pipe()
{

}

bool Pipe::exec(std::string& command, std::string& out, std::string& err)
{
  FILE *p = popen(command.c_str(), "r");
  if (!p)
    {
      err = strerror(errno);
      return false;
    }

  size_t n;
  char c;

  while (true)
    {
      // TODO: Bad, One character at a time.
      n = fread(&c, 1, 1, p);
      if (n == 0)
	break;
      if (n != 1)
	{
	  pclose(p);
	  err = strerror(errno);
	  return false;
	}
      out += c;
    }
  int status;
  wait(&status);
  if (status != 0)
    {
      // TODO: Possible some commands might not return 0
      err = _("Couldn't get the required content.");
      return false;
    }
  int x = pclose(p);
  if (errno == ECHILD)
    return true;
  // ECHILD
  // Probably it will always return -1 ?
  if (x == -1)
    {
      err = strerror(errno);
      return false;
    }
  return true;
}
