#ifndef _KAYAAPI_H // -*-C++-*-
#define _KAYAAPI_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

class Value;
class Array;

typedef Value* KayaValue;
typedef Array* KayaArray;

extern "C" {
    /// Make a new, uninitialised value.
    KayaValue newKayaValue();
    /// Make a new, empty array.
    KayaArray newKayaArray(int size);

    // Make new, initialised values.
    KayaValue KayaInt(int x);
    KayaValue KayaChar(char c);
    KayaValue KayaFloat(float f);
    KayaValue KayaString(char* str);
    KayaValue KayaUnion(int tag, int args);

    // Query basic values
    int KayaGetInt(KayaValue v);
    char KayaGetChar(KayaValue v);
    double KayaGetFloat(KayaValue v);
    char* KayaGetString(KayaValue v);
    KayaArray KayaGetArray(KayaValue v);

    // Set basic values
    void KayaSetInt(KayaValue v,int i);
    void KayaSetChar(KayaValue v,char c);
    void KayaSetFloat(KayaValue v,double f);
    void KayaSetString(KayaValue v,char* s);
    void KayaSetArray(KayaValue v,KayaArray a);

    // Array manipulation
    void KayaArrayPush(KayaArray a,KayaValue v);
    void KayaArraySet(KayaArray a, int index, KayaValue v);
    KayaValue KayaArrayLookup(KayaArray a, int index);
    int KayaArraySize(KayaArray a);

    // Unions
    int KayaUnionGetTag(KayaValue v);
    KayaValue KayaUnionGetArg(KayaValue v,int i);
    void KayaUnionSetArg(KayaValue v,int i,KayaValue val);

    // Callbacks
    KayaValue KayaCall(KayaValue fn, int args, ...);

    // Allocate a garbage collected block of memory (uses libgc)
    void* KayaAlloc(int size);

    // Handy function for combining an array into a bitmask.
    // The function <func> converts a kaya value (presumably a union) into a
    // C side bitmask; orArray iterates through the array ORing these values
    // together.
    int orArray(KayaArray a, int(*func)(KayaValue));

}

#endif
