// -*-C-*-ish

import Webprog;
import Crypto;
import HTMLDocument;

Void __panic(String err, Int code)
{
  putStrLn("Status: 500 Internal Server Error");
  putStrLn("Content-type: text/plain; charset=UTF-8");
  putStrLn("Cache-control: no-cache,private");
  putStrLn("");
  putStrLn("Kaya panic: "+err+" ("+code+")");
}

Void __start() {
    Prelude::gcIncremental();
    //    void(Prelude::gcSetFSD(2));
    try {
      Webprog::initWebApp();
      
      displayPage(module::webmain());
    } catch(err) {
      if (!Webprog::headersSent) {
	putStrLn("Status: 500 Internal Server Error");
	putStrLn("Content-type: text/plain; charset=UTF-8");
	putStrLn("Cache-control: no-cache,private");
	putStrLn("");
      }
      putStrLn("An error has occurred.");
      if (Webprog::debugMode) {
	exceptionBacktrace(err);
      } else {
	putStrLn("Error details suppressed to protect security.");
      }
    }
}
