{-
    Kaya - My favourite toy language.
    Copyright (C) 2004-2006 Edwin Brady

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module Main where

import Driver
import Options
import System
import Language
import Chaser

import Monad
import Debug.Trace

main :: IO ()
main = do args <- getArgs
	  (fn,extra,opts) <- usage args
	  let fn' = stripDot fn
          mt <- getDeps fn' opts []
          bw <- buildWhat opts mt
          buildAll opts extra (reverse bw)
          runProgram mt extra
	  exitWith ExitSuccess
  where stripDot ('.':'/':fn) = fn
	stripDot x = x

buildAll :: Options -> [String] -> [CompileNeeded] -> IO ()
buildAll _ extras [] = return ()
buildAll opts extras ((Comp fn ty mod need):xs)
   | not need = do when (not (quiet opts) && (ty/=Shebang)) $
                       putStrLn $ "Skipping " ++ show ty ++ " "++showuser mod
                   buildAll opts extras xs
   | otherwise = do when (not (quiet opts) && (ty/=Shebang)) $ 
                       putStrLn $ "Compiling " ++ show ty ++ " "++showuser mod
                    compileFile ty mod fn extras opts
                    buildAll opts extras xs

runProgram :: ModuleTree -> [String] -> IO ()
runProgram (Mod fn Shebang mod _) args
    = do exit <- system ("./"++(outputfile Shebang mod)++" "++showargs args)
	 if (exit /= ExitSuccess) 
	    then exitWith exit
	    else return ()
  where showargs [] = ""
        showargs (x:xs) = x ++ " " ++ showargs xs
runProgram _ _ = return ()


