/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GLIB_UTILS_H__
#define __GLIB_UTILS_H__

#include <glib.h>

G_BEGIN_DECLS

#if (GLIB_MAJOR_VERSION == 2) && (GLIB_MINOR_VERSION < 4)

typedef int GPid;

typedef void     (*GChildWatchFunc)   (GPid     pid,
				       gint     status,
				       gpointer data);
	
GSource *g_child_watch_source_new (GPid pid);

guint    g_child_watch_add_full (gint            priority,
				 GPid            pid,
				 GChildWatchFunc function,
				 gpointer        data,
				 GDestroyNotify  notify);
guint    g_child_watch_add      (GPid            pid,
				 GChildWatchFunc function,
				 gpointer        data);

GLIB_VAR GSourceFuncs g_child_watch_funcs;

GSource *g_child_watch_source_new (GPid pid);

guint    g_child_watch_add_full (gint            priority,
				 GPid            pid,
				 GChildWatchFunc function,
				 gpointer        data,
				 GDestroyNotify  notify);
guint    g_child_watch_add      (GPid            pid,
				 GChildWatchFunc function,
				 gpointer        data);

GLIB_VAR GSourceFuncs g_child_watch_funcs;

#endif
G_END_DECLS
#endif /* __GLIB_UTILS_H__ */
