/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002-2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_MOZ_THUMBNAIL_CREATOR_H__
#define __KZ_MOZ_THUMBNAIL_CREATOR_H__

#include <gtk/gtk.h>
#include <gtkmozembed.h>

G_BEGIN_DECLS

#define KZ_TYPE_MOZ_THUMBNAIL_CREATOR		(kz_moz_thumbnail_creator_get_type ())
#define KZ_MOZ_THUMBNAIL_CREATOR(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_MOZ_THUMBNAIL_CREATOR, KzMozThumbnailCreator))
#define KZ_MOZ_THUMBNAIL_CREATOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_MOZ_THUMBNAIL_CREATOR, KzMozThumbnailCreatorClass))
#define KZ_IS_MOZ_THUMBNAIL_CREATOR(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_MOZ_THUMBNAIL_CREATOR))
#define KZ_IS_MOZ_THUMBNAIL_CREATOR_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_MOZ_THUMBNAIL_CREATOR))
#define KZ_MOZ_THUMBNAIL_CREATOR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_MOZ_THUMBNAIL_CREATOR, KzMozThumbnailCreatorClass))

typedef struct _KzMozThumbnailCreator	KzMozThumbnailCreator;
typedef struct _KzMozThumbnailCreatorClass	KzMozThumbnailCreatorClass;

struct _KzMozThumbnailCreator
{
	/* embedding widget */
	GtkMozEmbed parent;
};

struct _KzMozThumbnailCreatorClass
{
	GtkMozEmbedClass parent_class;
};


GtkType      kz_moz_thumbnail_creator_get_type     (void);
KzMozThumbnailCreator
	    *kz_moz_thumbnail_creator_new          (void);
KzMozThumbnailCreator
	    *kz_moz_thumbnail_creator_get_instance (void);

void	     kz_moz_thumbnail_creator_create_next  (KzMozThumbnailCreator *creator);

void	     kz_moz_thumbnail_creator_append_queue (KzMozThumbnailCreator *creator,
						    gpointer data);

G_END_DECLS

#endif /* __KZ_MOZ_THUMBNAIL_CREATOR_H__ */
