/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   sirajr@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kfiledialog.h>
#include <kpushbutton.h>
#include <qlineedit.h>
#include <qimage.h>
#include <qiconset.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qapplication.h>
#include <kiconloader.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <qobjectlist.h>
#include <qspinbox.h>
#include <kglobal.h>
#include "../settings.h"
#include "kbfxcfgdialog.h"
#include <dcopref.h>
#include <kfiledialog.h>
#include <kinputdialog.h>
#include <qtabwidget.h>


KbfxCfgDialog::KbfxCfgDialog(QWidget *parent, const char *name)
:KbfxConfigDialogWidget(parent, name) {
    // load clear_left icon
    QIconSet icon = SmallIcon( QApplication::reverseLayout() ? "clear_left" : "locationbar_erase" );
    QIconSet refreshicon = SmallIcon( "reload" );

    //this->clearButton->setIconSet( icon );
    this->btnResetNormal->setIconSet( icon );
    this->btnResetPressed->setIconSet( icon );
    this->btnResetHover->setIconSet( icon );
    
    this->btnClearTop->setIconSet( icon );
    this->btnClearTop_2->setIconSet( icon );
    this->btnClearTop_3->setIconSet( icon );
    this->btnClearTop_4->setIconSet( icon );
    this->btnClearTop_5->setIconSet( icon );
    this->btnClearTop_6->setIconSet( icon );
    this->btnClearTop_7->setIconSet( icon );
    this->btnClearTop_8->setIconSet( icon );
    btnRefresh->setIconSet( refreshicon );

    QString pixmapStr;

    pixmapStr = KbfxCfg::normal();

    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixNormal->setPixmap( pixmap );
    }

    pixmapStr = KbfxCfg::hover();

    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixHover->setPixmap( pixmap );
    }

    pixmapStr = KbfxCfg::pressed();

    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixPressed->setPixmap( pixmap );
    }

    reloadThemeList();
    
    // refresh theme list
    this->mThemeFolderList = getThemes( KbfxCfg::themeFolder() );
    
    kcfg_ThemeList_activated( kcfg_ThemeList->currentText() );

    // prepare the folder browser
    KFile::Mode mode = static_cast<KFile::Mode>( KFile::Directory |
                       KFile::ExistingOnly |
                       KFile::LocalOnly );
    kcfg_ThemeFolder->setMode( mode );
}

void KbfxCfgDialog::btnResetPressed_clicked() {
    QString pixmapStr;
    pixmapStr = KbfxCfg::pressed();

    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixPressed->setPixmap( pixmap );
    }
}

void KbfxCfgDialog::btnResetNormal_clicked() {
    QString pixmapStr;
    pixmapStr = KbfxCfg::normal();

    this->kcfg_Normal->setURL( pixmapStr );

    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixNormal->setPixmap( pixmap );
    }
}

void KbfxCfgDialog::kcfg_Normal_urlSelected(const QString& pixmapStr) {
    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixNormal->setPixmap( pixmap );
    }
}

void KbfxCfgDialog::btnResetHover_clicked() {
    QString pixmapStr;
    pixmapStr = KbfxCfg::hover();

    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixHover->setPixmap( pixmap );
    }
}

void KbfxCfgDialog::kcfg_Hover_urlSelected(const QString& pixmapStr) {
    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixHover->setPixmap( pixmap );
    }
}

void KbfxCfgDialog::kcfg_Pressed_urlSelected(const QString& pixmapStr) {
    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixPressed->setPixmap( pixmap );
    }
}

void KbfxCfgDialog::loadConfig( ) {
    // normal
    this->kcfg_Normal->setURL(KbfxCfg::normal());

    // pressed
    this->kcfg_Pressed->setURL(KbfxCfg::pressed());

    // hover
    this->kcfg_Hover->setURL(KbfxCfg::hover());

    // enable glow
    this->kcfg_EnableGlow->setChecked(KbfxCfg::enableGlow());

    // auto adjust kicker
    this->kcfg_AutoAdjustKicker->setChecked(KbfxCfg::autoAdjustKicker());

    // tooltip
    this->kcfg_Tooltips->setText(KbfxCfg::tooltips());

    // theme
    this->kcfg_ThemeBg->setURL(KbfxCfg::themeBg());
    this->kcfg_ThemeTop->setURL(KbfxCfg::themeTop());
    this->kcfg_ThemeBottom->setURL(KbfxCfg::themeBottom());
    this->kcfg_ThemeMainBg->setURL(KbfxCfg::themeMainBg());
    this->kcfg_ThemeMask->setURL(KbfxCfg::themeMask());
    this->kcfg_ThemeCategory->setURL(KbfxCfg::themeCategory());
    this->kcfg_ThemeAppList->setURL(KbfxCfg::themeAppList());
    this->kcfg_ThemeListItem->setURL(KbfxCfg::themeListItem());
    this->kcfg_ThemeBgPaddingLeft->setValue(KbfxCfg::themeBgPaddingLeft());
    this->kcfg_ThemeBgPaddingRight->setValue(KbfxCfg::themeBgPaddingRight());
    
    this->kcfg_SearchBarTop->setValue( KbfxCfg::searchBarTop() );
    this->kcfg_SearchBarLeft->setValue( KbfxCfg::searchBarLeft() );
    this->kcfg_SearchBarWidth->setValue( KbfxCfg::searchBarWidth() );
    this->kcfg_SearchBarHeight->setValue( KbfxCfg::searchBarHeight() );
    this->kcfg_ContentSpacing->setValue( KbfxCfg::contentSpacing() );
    this->kcfg_CategoryItemHeight->setValue( KbfxCfg::categoryItemHeight() );
    this->kcfg_CategoryWidth->setValue( KbfxCfg::categoryWidth() );

    // update image
    this->kcfg_ThemeBg_urlSelected(KbfxCfg::themeBg());
    this->kcfg_ThemeTop_urlSelected(KbfxCfg::themeTop());
    this->kcfg_ThemeBottom_urlSelected(KbfxCfg::themeBottom());
    this->kcfg_ThemeMainBg_urlSelected(KbfxCfg::themeMainBg());
    this->kcfg_ThemeMask_urlSelected(KbfxCfg::themeMask());
    //this->kcfg_ThemeListItem_urlSelected(KbfxCfg::themeListItem());

    //menutype=KbfxCfg::menuType();
    this->kcfg_MenuType->setCurrentText(KbfxCfg::menuType());
    // themes
    //this->kcfg_ThemeList->clear();
    //this->btnBrowse_clicked();

    //this->kcfg_ThemeList->insertStringList(KbfxCfg::themeList());
    this->kcfg_ThemeList->setCurrentText(KbfxCfg::themeName());

    this->kcfg_ThemeFolder->setURL( KbfxCfg::themeFolder() );
}

void KbfxCfgDialog::saveConfig( ) {
    KbfxCfg::setNormal( this->kcfg_Normal->url() );
    KbfxCfg::setPressed( this->kcfg_Pressed->url() );
    KbfxCfg::setHover( this->kcfg_Hover->url() );

    KbfxCfg::setEnableGlow( this->kcfg_EnableGlow->isChecked() );
    KbfxCfg::setAutoAdjustKicker( this->kcfg_AutoAdjustKicker->isChecked() );

    KbfxCfg::setTooltips( this->kcfg_Tooltips->text() );

    KbfxCfg::setThemeBg( this->kcfg_ThemeBg->url() );
    KbfxCfg::setThemeBottom( this->kcfg_ThemeBottom->url() );
    KbfxCfg::setThemeTop( this->kcfg_ThemeTop->url() );
    KbfxCfg::setThemeMainBg( this->kcfg_ThemeMainBg->url() );
    KbfxCfg::setThemeMask( this->kcfg_ThemeMask->url() );
    KbfxCfg::setThemeListItem( this->kcfg_ThemeListItem->url() );
    KbfxCfg::setThemeCategory( this->kcfg_ThemeCategory->url() );
    KbfxCfg::setThemeAppList( this->kcfg_ThemeAppList->url() );
    
    // dimension and position
    KbfxCfg::setThemeBgPaddingLeft( this->kcfg_ThemeBgPaddingLeft->value() );
    KbfxCfg::setThemeBgPaddingRight( this->kcfg_ThemeBgPaddingRight->value() );
    KbfxCfg::setSearchBarTop(this->kcfg_SearchBarTop->value() );
    KbfxCfg::setSearchBarLeft(this->kcfg_SearchBarLeft->value() );
    KbfxCfg::setSearchBarWidth(this->kcfg_SearchBarWidth->value() );
    KbfxCfg::setSearchBarHeight(this->kcfg_SearchBarHeight->value() );
    KbfxCfg::setContentSpacing(this->kcfg_ContentSpacing->value() );
    KbfxCfg::setCategoryItemHeight(this->kcfg_CategoryItemHeight->value() );
    KbfxCfg::setCategoryWidth(this->kcfg_CategoryWidth->value() );
    

    KbfxCfg::setThemeName( this->kcfg_ThemeList->currentText() );
    KbfxCfg::setThemeFolder( this->kcfg_ThemeFolder->url() );
    KbfxCfg::setMenuType( this->kcfg_MenuType->currentText());

    KbfxCfg::writeConfig();

    notifyApplet();
}

void KbfxCfgDialog::kcfg_ThemeTop_urlSelected(const QString& pixmapStr) {
    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixTop->setPixmap( pixmap );
    }
}

void KbfxCfgDialog::kcfg_ThemeBg_urlSelected(const QString& pixmapStr) {
    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixBg->setPixmap( pixmap );
    }
}

void KbfxCfgDialog::kcfg_ThemeBottom_urlSelected(const QString& pixmapStr) {
    if (pixmapStr) {
        // set image
        QImage pixmap = QImage( pixmapStr );
        //if (pixmap.isNull)
        this->pixBottom->setPixmap( pixmap );
    }
}

void KbfxCfgDialog::kcfg_ThemeMainBg_urlSelected(const QString&) {
    // preview tab pixmap
}

void KbfxCfgDialog::kcfg_ThemeMask_urlSelected(const QString&) {
    // preview mask pixmap
}

QStringList KbfxCfgDialog::getThemes( const QString& themeFolder ) {
    QStringList res;

    QDir d( themeFolder );

    //qDebug(QString("About to check %1 for kbfx theme").arg(themeFolder));
    //kdDebug() << QString("About to check %1 for kbfx theme").arg(themeFolder) << endl;
    for ( int i = 0; i < d.count(); i++ ) {
        // need to verify each theme folder: here we need some kinda themefolder and theme file spec
        //qDebug(QString("Checking %1 in %2").arg(d[i]).arg(themeFolder));
      ///kdDebug() << QString("Checking %1 in %2").arg(d[i]).arg(themeFolder) << endl;
        QString kbfxThemeFolder = themeFolder + '/' + d[i];

        if ( isValidThemeFolder( kbfxThemeFolder ) )
            res.append( kbfxThemeFolder );
    }

    return res;
}

bool KbfxCfgDialog::isValidThemeFolder( const QString & themeFolder ) {
    // meanwhile we'll return true
    // find a *.kbfxtheme
    if (QFile::exists(themeFolder + "/theme.kbfx"))
        return true;
    else
        return false;
}

void KbfxCfgDialog::btnRefresh_clicked() {
    // fill theme list
    this->mThemeFolderList = getThemes( kcfg_ThemeFolder->url() );
    reloadThemeList();
}

QString KbfxCfgDialog::getThemeProp( const QString& themeFile, const QString& key ) {
    KSimpleConfig *ksc = new KSimpleConfig( themeFile, true);
    ksc->reparseConfiguration();

    QMap<QString,QString> map = ksc->entryMap( "Theme" );

    //qDebug( QString("Value for key '%1': '%2'").arg(key).arg(map[key]));
    //kdDebug() << QString("Value for key '%1': '%2'").arg(key).arg(map[key]) << endl;

    return map[key];
}

bool KbfxCfgDialog::applyTheme( const QString & themeName ) {
    int themeIndex;
    bool themeFound = false;

    if (themeName == "default") {
        this->loadDefaultTheme();
        return true;
    }

    for ( int i = 0; i < this->mThemeFolderList.count(); i++ ) {
        QString path = this->mThemeFolderList[i];
        QString themeFile = path + "/theme.kbfx";
        QString themeNameFromFile = getThemeProp( themeFile, "ThemeName");

        //qDebug( QString("comparing '%1' to '%2'").arg(themeName).arg( themeNameFromFile ) );
        //kdDebug() << QString("comparing '%1' to '%2'").arg(themeName).arg( themeNameFromFile ) << endl;
        if ( themeName == themeNameFromFile ) {
            themeIndex = i;
            themeFound = true;
            break;
        }
    }

    if (not themeFound)
        return false;
    else {
        QString path = this->mThemeFolderList[themeIndex] + "/";
        QString themeFile = path + "theme.kbfx";
        
        QMap<QString,QString> themeCfg = getThemeConfig(themeFile);

        //qDebug( QString("applying from path: '%1'").arg(path));
        //kdDebug() << QString("applying from path: '%1'").arg(path) << endl;

        // apply theme
        QString top = themeCfg[ "Top"];
        QString bg = themeCfg[ "Bg"];
        QString bottom = themeCfg[ "Bottom"];
        QString tab = themeCfg[ "MainBg"];
        QString mask = themeCfg[ "Mask"];

        // theme
        this->kcfg_ThemeBg->setURL(bg);
        this->kcfg_ThemeTop->setURL(top);
        this->kcfg_ThemeBottom->setURL(bottom);
        this->kcfg_ThemeMainBg->setURL(tab);
        this->kcfg_ThemeMask->setURL(mask);

        this->kcfg_ThemeCategory->setURL(themeCfg[ "CategoryBg"]);
        this->kcfg_ThemeAppList->setURL(themeCfg[ "AppListBg"]);
        this->kcfg_ThemeListItem->setURL(themeCfg[ "SelectedBg"]);
        this->kcfg_ThemeBgPaddingLeft->setValue( themeCfg["PaddingLeft"].toInt() );
        this->kcfg_ThemeBgPaddingRight->setValue( themeCfg[ "PaddingRight"].toInt() );
        
        this->kcfg_SearchBarTop->setValue( themeCfg["SearchTop"].toInt() );
        this->kcfg_SearchBarLeft->setValue( themeCfg["SearchLeft"].toInt() );
        this->kcfg_SearchBarWidth->setValue( themeCfg["SearchWidth"].toInt() );
        this->kcfg_SearchBarHeight->setValue( themeCfg["SearchHeight"].toInt() );
        this->kcfg_ContentSpacing->setValue( themeCfg["ContentSpacing"].toInt() );
        this->kcfg_CategoryItemHeight->setValue( themeCfg["CategoryItemHeight"].toInt() );
        this->kcfg_CategoryWidth->setValue( themeCfg["CategoryWidth"].toInt() );

        // update image
        this->kcfg_ThemeBg_urlSelected(bg);
        this->kcfg_ThemeTop_urlSelected(top);
        this->kcfg_ThemeBottom_urlSelected(bottom);
        this->kcfg_ThemeTab_urlSelected(tab);
        this->kcfg_ThemeMask_urlSelected(mask);

        return true;
    }
}

void KbfxCfgDialog::btnApplyTheme_clicked() {
    if ( kcfg_ThemeList->currentText().isEmpty() )
        return;
    else
        if ( not applyTheme(kcfg_ThemeList->currentText()) )
            KMessageBox::sorry( (QWidget*) this, "Invalid theme file" );
        else {
            saveConfig();
            KMessageBox::information( (QWidget*) this, "Theme has been succesfully applied" );
        }
}

void KbfxCfgDialog::reloadThemeList( ) {
    kcfg_ThemeList->clear();

    // insert default theme
    kcfg_ThemeList->insertItem( "default" );

    for (int i=0; i < this->mThemeFolderList.count(); i++) {
        QString themeName = getThemeProp( this->mThemeFolderList[i] + "/theme.kbfx", "ThemeName" );
        //qDebug(QString("inserting '%1'").arg(themeName));
        //kdDebug() << QString("inserting '%1'").arg(themeName) << endl;;
        kcfg_ThemeList->insertItem( themeName );
    }
}


void KbfxCfgDialog::menuTypeSet(const QString & x) {
    //kdDebug() << "menuTypeSet: " << x << endl;
    KbfxCfg::setMenuType(x);
}

void KbfxCfgDialog::loadDefaultTheme( ) {
    // apply theme
    QString top = "";
    QString bg = "";
    QString bottom = "";
    QString mainbg = "";
    QString mask = "";

    // theme
    this->kcfg_ThemeBg->setURL(bg);
    this->kcfg_ThemeTop->setURL(top);
    this->kcfg_ThemeBottom->setURL(bottom);
    this->kcfg_ThemeMainBg->setURL(mainbg);
    this->kcfg_ThemeMask->setURL(mask);
    
    this->kcfg_ThemeCategory->setURL("");
    this->kcfg_ThemeAppList->setURL("");
    this->kcfg_ThemeListItem->setURL("");
    this->kcfg_ThemeBgPaddingLeft->setValue( 0 );
    this->kcfg_ThemeBgPaddingRight->setValue( 0 );
    
    this->kcfg_SearchBarTop->setValue( 0 );
    this->kcfg_SearchBarLeft->setValue( 0 );
    this->kcfg_SearchBarWidth->setValue( 150 );
    this->kcfg_SearchBarHeight->setValue( 24 );
    this->kcfg_ContentSpacing->setValue( 0 );
    this->kcfg_CategoryItemHeight->setValue( 24 );
    this->kcfg_CategoryWidth->setValue( 150 );

    // update image
    this->kcfg_ThemeBg_urlSelected(bg);
    this->kcfg_ThemeTop_urlSelected(top);
    this->kcfg_ThemeBottom_urlSelected(bottom);
    this->kcfg_ThemeMainBg_urlSelected(mainbg);
    this->kcfg_ThemeMask_urlSelected(mask);
}

void KbfxCfgDialog::notifyApplet( ) {
    DCOPRef m_kickerkbfxInterface("kicker","kbfxInterface");

    if(m_kickerkbfxInterface.call("notifyConfigChange()"))
        //emit changed(true);
        qDebug("KBFX applet notified");
    else
        qDebug("Unable to notify KBFX applet");
    //kicker kbfxInterface notifyConfigChange
}

void KbfxCfgDialog::saveThemeConfig(QString& filename, QString& themeName)
{
    KSimpleConfig *ksc = new KSimpleConfig( filename );
    
    ksc->setGroup( "Theme" );
    ksc->writeEntry( "ThemeName", themeName );
    ksc->writeEntry( "Bg", this->kcfg_ThemeBg->url() );
    ksc->writeEntry( "Bottom", this->kcfg_ThemeBottom->url() );
    ksc->writeEntry( "Top", this->kcfg_ThemeTop->url() );
    ksc->writeEntry( "MainBg", this->kcfg_ThemeMainBg->url() );
    ksc->writeEntry( "Mask", this->kcfg_ThemeMask->url() );
    ksc->writeEntry( "SelectedBg", this->kcfg_ThemeListItem->url() );
    ksc->writeEntry( "CategoryBg", this->kcfg_ThemeCategory->url() );
    ksc->writeEntry( "AppListBg", this->kcfg_ThemeAppList->url() );
    
    // dimension and position
    ksc->writeEntry( "Paddingleft", this->kcfg_ThemeBgPaddingLeft->value() );
    ksc->writeEntry( "PaddingRight", this->kcfg_ThemeBgPaddingRight->value() );
    ksc->writeEntry( "SearchTop", this->kcfg_SearchBarTop->value() );
    ksc->writeEntry( "SearchLeft", this->kcfg_SearchBarLeft->value() );
    ksc->writeEntry( "SearchWidth", this->kcfg_SearchBarWidth->value() );
    ksc->writeEntry( "SearchHeight", this->kcfg_SearchBarHeight->value() );
    ksc->writeEntry( "ContentSpacing", this->kcfg_ContentSpacing->value() );
    ksc->writeEntry( "CategoryItemHeight", this->kcfg_CategoryItemHeight->value() );
    ksc->writeEntry( "CategoryWidth", this->kcfg_CategoryWidth->value() );

    ksc->sync();
}

void KbfxCfgDialog::btnSaveAs_clicked()
{
    bool res;
    QString themename = KInputDialog::getText("New KBFX Theme", "Theme Name", "", &res );

    if (themename.isNull() || !res) 
        return;

    //KMessageBox::information( this, "save!!" );
    KFileDialog savedlg( QString::null, "*.kbfx|KBFX theme file\n*.*|Any files", (QWidget *) this, "kbfxsavedlg", true);

    QString filename = savedlg.getSaveFileName();
    
    if ( !filename.isNull() ) {
        saveThemeConfig( filename, themename );
        KMessageBox::information( (QWidget*) this, "Theme has been succesfully saved" );
    }
}

void KbfxCfgDialog::kcfg_ThemeList_activated(const QString& themename)
{
    //kdDebug() << "about to apply theme: " << themename;

    tabConfig->setEnabled( themename != "default" );
        
    if ( !applyTheme( themename ) )
         KMessageBox::sorry( (QWidget*) this, "Invalid theme file" );
}

void KbfxCfgDialog::btnSaveTheme_clicked()
{
    int themeIndex;
    bool themeFound = false;
    QString themeName = kcfg_ThemeList->currentText();

    if (themeName == "default") {
        this->loadDefaultTheme();
        return;
    }

    for ( int i = 0; i < this->mThemeFolderList.count(); i++ ) {
        QString path = this->mThemeFolderList[i];
        QString themeFile = path + "/theme.kbfx";
        QString themeNameFromFile = getThemeProp(themeFile, "ThemeName");

        //qDebug( QString("comparing '%1' to '%2'").arg(themeName).arg( themeNameFromFile ) );
        //kdDebug() << QString("comparing '%1' to '%2'").arg(themeName).arg( themeNameFromFile ) << endl;
        if ( themeName == themeNameFromFile ) {
            themeIndex = i;
            themeFound = true;
            break;
        }
    }

    if (not themeFound) {
        KMessageBox::error( (QWidget*) this, "Theme file not found" );
        return;
    } else {
        QString path = this->mThemeFolderList[themeIndex] + "/";
        QString themeFile = path + "theme.kbfx";
        //kdDebug() << "Saving: " << themeFile;
        saveThemeConfig( themeFile, themeName );
        KMessageBox::information( (QWidget*) this, "Theme file has been successfully saved" );
    }

}

QMap<QString,QString> KbfxCfgDialog::getThemeConfig(const QString& themeFile) {
    KSimpleConfig *ksc = new KSimpleConfig( themeFile, true);
    ksc->reparseConfiguration();

    return ksc->entryMap( "Theme" );
}

#include "kbfxcfgdialog.moc"
