/***************************************************************************
 *   Copyright (C) 2005 by Akhmad Fathonih   *
 *   toni@gamatechno.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qlayout.h>

#include <klocale.h>
#include <kglobal.h>
#include <kparts/genericfactory.h>

#include "kcmkbfx.h"
#include <dcopclient.h>
#include <kconfigdialogmanager.h>
#include <kconfigdialog.h>
#include <kdialogbase.h>
#include "../settings.h"
#include "kbfxcfgdialog.h"
#include <qlineedit.h>
#include <kglobal.h>
#include <kmessagebox.h>
#include <dcopref.h>

typedef KGenericFactory<kcmkbfx, QWidget> kcmkbfxFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kcmkbfx, kcmkbfxFactory("kcmkbfx"))

kcmkbfx::kcmkbfx(QWidget *parent, const char *name, const QStringList&)
    : KCModule(parent, name), myAboutData(0)
{
    KAboutData *about =
            new KAboutData(I18N_NOOP("kcmkbfx"), I18N_NOOP("KDE Panel Control Module"),
                           0, 0, KAboutData::License_GPL,
                           I18N_NOOP("(c) 2005 Akhmad Fathonih"));

    about->addAuthor("Akhmad Fathonih", 0, "akhmadf@gmail.com");

    setAboutData( about );
    
    cfgdlg = new KbfxCfgDialog(this); 
     
    // put the widget in strecth mode
    QVBoxLayout *layout = new QVBoxLayout(this, 0, KDialog::spacingHint());
    layout->addWidget(cfgdlg);
    //layout->addStretch();
    
    // add managed widget capability (aka widget monitoring)
    addConfig(KbfxCfg::self(), cfgdlg);
    
    load();
};


kcmkbfx::~kcmkbfx()
{
}


void kcmkbfx::load()
{
    // insert your loading code here...
    cfgdlg->loadConfig();
}


void kcmkbfx::defaults()
{
    // insert your default settings code here...
    emit changed(true);
}


void kcmkbfx::save()
{
    // insert your saving code here...
    cfgdlg->saveConfig();
}


int kcmkbfx::buttons()
{
    return KCModule::Default|KCModule::Apply|KCModule::Help;
}


void kcmkbfx::configChanged()
{
    // insert your saving code here...
    emit changed(true);
}


QString kcmkbfx::quickHelp() const
{
    return i18n("Helpful information about the kcmkbfx module.");
}


#include "kcmkbfx.moc"
