/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "spinxtop.h"
#include <stdio.h>
#include <kpixmapeffect.h>
#include <kimageeffect.h>
#include <qbutton.h>
#include "../imagesource/menu_arrow_up.xpm"
#include "../imagesource/menu_arrow_down.xpm"



KbfxSpixTop::KbfxSpixTop (QWidget * parent, const char *name):
QLabel (parent, name, WNoAutoErase)
{

  setLineWidth (0);
  setScaledContents (false);
  moseEnter = 0;

//FIXME:add default if not found
  down = getKDEIcon ("menu_arrow_down");
  up = getKDEIcon ("menu_arrow_up");

  scrollText_up = getKDEIcon ("menu_scroll_up");
  scrollText_down = getKDEIcon ("menu_scroll_down");
  scrollText_settings = getKDEIcon ("menu_change_the_settings");;
  _frame = 0;
  _in = 0;
  _inte = 0.2;
  _timer = new QTimer(this);
  QTimer *t = new QTimer (this);
  connect (t, SIGNAL (timeout ()), this, SLOT (animate ()));
  connect (_timer, SIGNAL (timeout ()), this, SLOT (animateScrollBar ()));
  t->start (150, FALSE);
  _downOffSet = this->height()/2;//this->height () - (down.height () + 5);
  _upOffSet = this->height()/2;
  _opacity = 0.0;
}


void
KbfxSpixTop::mousePressEvent (QMouseEvent * e)
{
  if (e->x () >= this->width () - 40 && e->y () >= this->height () - 30)
    {
      qDebug ("Scroll up");
      emit scroll (-120);
    }
  else
    {
      emit scroll (120);
      qDebug ("INvalid click");
      this->update ();
    }
}

QPixmap KbfxSpixTop::getKDEIcon (QString src)
{
  KIconLoader *
    iconload = KGlobal::iconLoader ();
  QString
    iconfile = iconload->iconPath (src, KIcon::Desktop, false);
  return QPixmap (iconfile);
}

QPixmap KbfxSpixTop::compositePixmap (QPixmap src, QPixmap dest)
{

  QImage
  srcImg (src.convertToImage ());
  QImage
  boundBoxImg (boundBox.convertToImage ());
  QImage
  userImageImg (userImage.convertToImage ());

  userImageImg = KImageEffect::intensity (userImageImg, _inte);

  int
    _paddingX = ((boundBox.height () - userImage.height ()) / 2) + 5;

  bitBlt (&dest, 4, 4, &boundBoxImg, 0, 0, boundBox.width (),
	  boundBox.height (), 0);
  bitBlt (&dest, _paddingX, _paddingX, &userImageImg, 0, 0,
	  userImage.width (), userImage.height (), 1);


  QPixmap
  newmaintop (dest);


// 
  return newmaintop;

}

QString KbfxSpixTop::getUserName ()
{

  KUser *
    user = new KUser ();
  QString
  logInName (user->loginName ());
//Nookie say some might find it discriminating.. dont want that.
      if( logInName == "root")
              logInName = QString("Administrator");

  return logInName.upper ();



}

void
KbfxSpixTop::paintEvent (QPaintEvent * pe)
{

//  _downOffSet = this->height () - (down.height () + 5);
  const QRect r = pe->rect ();
  QPixmap *_m_bg = (this->pixmap ());
  *_m_bg = this->compositePixmap (*_m_bg, *_m_bg);

  QPainter p;
  p.begin (this);
  if (!_m_bg->isNull ())
    {
//p.begin(this);
      p.drawPixmap (r, *_m_bg);

      p.setPen (QColor (255, 255, 255));

      QFont *let = new QFont ();
      let->setBold (true);
      let->setPointSize (10);
      p.setFont (*let);
      p.drawText (boundBox.width () + 15,
		  5, 200, 20, Qt::SingleLine, this->getUserName ());
      let->setBold (false);
      let->setPointSize (6);
      p.setFont (*let);

      p.drawPixmap (QRect
		    (boundBox.width () + 17, 28, scrollText_settings.width (),
		     scrollText_settings.height ()), scrollText_settings);



      if (moseEnter)
	{

	  p.setBrush (QColor (255, 255, 255));
//


//
	  p.drawPixmap (QRect
			(this->width () - (down.width () + 5),
			 (_downOffSet), 9, 11),
			down);
	  p.drawPixmap (QRect
			(this->width () - (down.width () + 5), _upOffSet, 9, 11), up);

	  p.drawPixmap (QRect
			(this->width () -
			 (scrollText_up.width () + down.width () + 14),
			 up.height () - 3, scrollText_up.width (),
			 scrollText_up.height ()), scrollText_up);

	  p.drawPixmap (QRect
			(this->width () -
			 (scrollText_down.width () + down.width () +
			  abs (scrollText_down.width () -
			       scrollText_up.width ())),
			 (this->height () - (down.width () + 5)) + 1,
			 scrollText_down.width (), scrollText_down.height ()),
			scrollText_down);

	}

      p.end ();
    }

}

void
KbfxSpixTop::timerEvent (QTimerEvent * e)
{

}


void 
KbfxSpixTop::animate()
{

    if (_frame == 5)
      {
	_frame = 0;
	_inte = 0.001;
      }


    else
      {
	if (_in == 1)
	  {
	    _frame--;
	    _inte -= 0.001;
	  }
	else
	  {
	    _frame++;
	    _inte += 0.1;
	  }
	   if (_frame == 0)
	       _in = 0;
      }


    this->update ();


}

void 
KbfxSpixTop::animateScrollBar()
{
if( _downOffSet <  this->height () - (down.height () + 5))  
{
_downOffSet++;
}

if(_upOffSet > 4)
{
_upOffSet--;

}

_opacity +=0.1;
}

KbfxSpixTop::~KbfxSpixTop ()
{


}
