/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef MAIN_WIN_H
#define MAIN_WIN_H
#include <qwidget.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qimage.h>
#include <kuser.h>		//drop suppor for kde 3.2 , sorry
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kicontheme.h>
#include <kprocess.h>
#include <qheader.h>
#include <qfileinfo.h>
#include <krun.h>
#include <kurl.h>
#include <kservice.h>
#include <kservicegroup.h>
#include <qstringlist.h>
#include <khtml_part.h>
#include <khtmlview.h>
#include <kmainwindow.h>
#include <kapp.h>
#include "kbfxconfig.h"
#include <qdir.h>
#include <qlabel.h>



/**
@author Siraj Razick
*/

class MainWindow : public QWidget
{

Q_OBJECT 

public:
MainWindow(const char * name);

virtual   void mousePressEvent( QMouseEvent *);
virtual   void mouseMoveEvent( QMouseEvent *);
	  void handleOrangePannel(const KURL & url);
          QString  getHTMLThemeList(QString path);
signals:
    void shutdown();
public slots:
    void    setHexMode(){}
    void changeLocation();
    void openURLRequest(const KURL &url, const KParts::URLArgs & );
    void formSubmitNotification   (   const char *   action, 
  						const QString &   url, 
  						const QByteArray &   formData, 
						const QString &   target, 
  						const QString &   contentType, 
  						const QString &   boundary
  );
private: 

void loadHTML(QString url);
void parseHTML();
KHTMLPart * browser;
QString * HTML;
QPoint clickPos;

};

#endif
