/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kbfxvista.h"
//#include "settings.h"
#include <kglobal.h>
#include <qbitmap.h>
#include <stdio.h>
#include <krun.h>
#include <kpassivepopup.h>
#include "kbfxconfig.h"
//#include "settings.h"

kbfxvista::kbfxvista (const QString & configFile, Type type, int actions,
		      QWidget * parent, const char *name):
KPanelApplet (configFile, type, actions, parent, name),
DCOPObject ("kbfxInterface")
{
  wait_dcop = 0;
  dcop = new DCOPClient ();
  dcop->attach ();
  setAcceptDrops (true);
  readConfig ();
  blocked = 0;
  _clicked = 0;
  button = new kbfx_vista_button (this);

  connect (button, SIGNAL (skinLoadComplete ()), button,
	   SLOT (skinLoadCompleteSlot ()));
  connect (this, SIGNAL (enter ()), button, SLOT (onMouseOverSlot ()));
  connect (button, SIGNAL (sizechange ()), this, SLOT (reajust ()));
  connect (this, SIGNAL (leave ()), button, SLOT (onMouseLeaveSlot ()));
  connect (this, SIGNAL (clicked ()), button, SLOT (onMouseClickSlot ()));


  QTimer::singleShot (100, this, SLOT (menuInit ()));
  button->kbfx_vista_button_loadSkins (skin, skin_hover, skin_pressed);

  button->installEventFilter (this);
  reajust ();
  button->show ();
  button->repaint ();
  m_tooltip = true;


}

void
kbfxvista::reajust ()
{
  if (kicker_auto_ajust)
    {
      QByteArray data;
      QDataStream arg (data, IO_WriteOnly);
      arg << button->height ();
      if (!dcop->send ("kicker", "Panel", "setPanelSize(int)", data))
	kdWarning () << "Could not send DCOP command\n";
    }

}

void
kbfxvista::menuInit ()
{

//

  menu = new KPopupMenu (this);
  a = new vista (menu);
  connect (a, SIGNAL (hide ()), this, SLOT (resetButton ()));
  readConfig ();

  QImage tmp (theme + "/bg.png");

  if (tmp.isNull ())
    {
      theme = locate ("data", "kbfx/skins/default/bg.png");
      theme.replace ("bg.png", "");
      //qDebug ("Null Theme Folder**falling back to default path ::" + theme);
    }


  a->setThemeName (theme);

//FIX ME replace this with a for loop and a array of images
//Pass as array of Pixmaps :simplyfiy design

QString m_skinList[] = {
			"topbg.png",
			"botbg.png",
			"bg.png",
			"tabbg.png",
			"listboxbg.png",
			"tilenormal.png",
			"tilehover.png",
			"rhstile.png",
			"rhshovertile.png",
			"logout.png",
			"lock.png",
			
			
			
			}; 

  QPixmap top;
  QImage topimg (theme + "/" + "topbg.png");
  top.convertFromImage (topimg);


  QPixmap bot;
  QImage botimg (theme + "/" + "botbg.png");
  bot.convertFromImage (botimg);

  QPixmap bgi;
  QImage bgiimg (theme + "/" + "bg.png");
  bgi.convertFromImage (bgiimg);

  QPixmap tab;
  QImage tabimg (theme + "/" + "tabbg.png");
  tab.convertFromImage (tabimg);

  QPixmap listboxbg;
  QImage listboxbgimg (theme + "/" + "listboxbg.png");
  listboxbg.convertFromImage (listboxbgimg);

  QPixmap tile;
  QImage tileimg (theme + "/" + "tilenormal.png");
  tile.convertFromImage (tileimg);

  QPixmap tileHover;
  QImage tilehoverimg (theme + "/" + "tilehover.png");
  tileHover.convertFromImage (tilehoverimg);

  QPixmap rhstile;
  QImage rhsimg (theme + "/" + "rhstile.png");
  rhstile.convertFromImage (rhsimg);

  QPixmap rhshtile;
  QImage rhshimg (theme + "/" + "rhshovertile.png");
  rhshtile.convertFromImage (rhshimg);

  QPixmap logoutimg;
  QImage logout (theme + "/" + "logout.png");
  logoutimg.convertFromImage (logout);

  QPixmap lockimg;
  QImage lock (theme + "/" + "lock.png");
  lockimg.convertFromImage (lock);

  QPixmap lockimghover;
  QImage lockhover (theme + "/" + "lockhover.png");
  lockimghover.convertFromImage (lockhover);

  QPixmap logoutimghover;
  QImage logouthover (theme + "/" + "logouthover.png");
  logoutimghover.convertFromImage (logouthover);

  QPixmap person;
  QImage personimg (theme + "/" + "dudebox.png");
  person.convertFromImage (personimg);



  QPixmap listimg;
  QImage list (theme + "/" + "appfind.png");
  listimg.convertFromImage (list);


  QPixmap findimg;
  QImage find (theme + "/" + "find.png");
  findimg.convertFromImage (find);



//  if (listboxbg.isNull ())
    //qDebug ("ListBox Pixmap setting failed");


  QPixmap maski;
  QImage maskiimg (theme + "/" + "mask.png");
  maski.convertFromImage (maskiimg);

  QImage sepimg ( theme + "/" +"separator.png");
  QPixmap sep(sepimg);

  a->KappbarSetTileImages (tile, tileHover, rhstile, rhshtile,sep);
  a->KAppBarSetTheme (top, bgi, tab, bot, maski, listboxbg, logoutimg,
		      logoutimghover, lockimghover, lockimg, listimg, findimg,
		      person);


  if (!maski.isNull ())
    {

      if (!maski.mask ())
	{
	  if (!maskiimg.hasAlphaBuffer ())
	    {
	      //qDebug ("Creating AplhaMask");
	      QBitmap bitmap;
	      bitmap = maskiimg.createAlphaMask ();
	      maski.setMask (bitmap);
	    }
	  else
	    {
	      //qDebug ("Creating Hurestic Mask");
	      QBitmap bitmap;
	      bitmap = maskiimg.createHeuristicMask ();
	      maski.setMask (bitmap);
	    }
	}

      if (maski.mask ())
	menu->setMask (*maski.mask ());


    }

  menu->insertItem (a, 0);

  emit enter ();
//emit pressed();
  emit leave ();

}


kbfxvista::~kbfxvista ()
{
  saveConfig ();
  delete (button);
}


void
kbfxvista::about ()
{
//do some things !
}


void
kbfxvista::help ()
{
  KMessageBox::information (0, i18n ("Visit http://www.kbfx.org/"));
}


void
kbfxvista::preferences ()
{

  KRun::runCommand ("kbfxconfigapp");


}

int
kbfxvista::widthForHeight (int height) const 
{

  height = height;

  return button->width ();
}

int
kbfxvista::heightForWidth (int width) const 
{
  width = width;
  return button->height ();
}

void
kbfxvista::resizeEvent (QResizeEvent * e)
{
  KPanelApplet::resizeEvent (e);
}


void
kbfxvista::showStartMenu ()
{

  QByteArray data;
  QByteArray rdata;
  QDataStream arg (data, IO_WriteOnly);
  QCString replytype;
  blocked = 1;

  if (_clicked == 0)
    {
      _clicked = 1;
      arg << menupos ();
      if (!dcop->
	  send ("kicker", "kbfxInterface", "showKbfxMenu(QPoint)", data))
	{
	  kdWarning () <<
	    "**KBFX-APPLET-FATAL_ERROR:Could not send DCOP command\n";
	}
    }
  else
    {
      _clicked = 0;
      blocked = 0;
      emit leave ();
    }
}

bool
kbfxvista::eventFilter (QObject * o, QEvent * e)
{
  o = o;

  QCursor kbfxCursor;
  kbfxCursor.setShape (Qt::PointingHandCursor);
  this->setCursor ((const QCursor) kbfxCursor);


  switch (e->type ())
    {

    case QEvent::Enter:
      {
	if (blocked == 0)
	  {
	    emit enter ();
	    _clicked = 0;

	    this->showToolTip ();
	  }
	return TRUE;
      }
    case QEvent::Leave:
      {
	if (blocked == 0)
	  emit leave ();
	return TRUE;
      }
    case QEvent::MouseButtonPress:
      {

	emit clicked ();
	showStartMenu ();
	//  _clicked = 1;
	return TRUE;
      }
    case QEvent::MouseButtonRelease:
      {
	return TRUE;
      }
    default:
      return FALSE;

    }

}


void
kbfxvista::resetButton ()
{
  _clicked = 0;
  blocked = 0;
}

extern "C"
{
  KPanelApplet *init (QWidget * parent, const QString & configFile)
  {
    KGlobal::locale ()->insertCatalogue ("kbfxspinx");
    return new kbfxvista (configFile, KPanelApplet::Normal,KPanelApplet::
			  Help | KPanelApplet::Preferences, parent,
			  "kbfxspinx");
  }
}

void
kbfxvista::readConfig ()
{
//  static_cast < KConfigSkeleton * >(KbfxCfg::self ())->readConfig ();
 
  ConfigInit ().read ();
  ConfigInit().confskel->readConfig();
  skin = ConfigInit ().m_KbfxNormalButtonPath;
  skin_pressed = ConfigInit ().m_KbfxPressedButtonPath;
  skin_hover = ConfigInit ().m_KbfxHoverButtonPath;

// fx_on = KbfxCfg::enableGlow ();
// tooltip = KbfxCfg::tooltips ();
// kicker_auto_ajust = KbfxCfg::autoAdjustKicker ();
// bartype = KbfxCfg::menuType ();
// kdDebug () << "Menutype: " << KbfxCfg::menuType () << endl;
  fx_on  = false;
  kicker_auto_ajust = true;
  theme = ConfigInit ().m_SpinxThemeBasePath + "/"+ConfigInit ().m_SpinxThemeName+"/";
  //qDebug ("Current Theme is set to -=======================>" + theme);
  m_tooltip = ConfigInit().m_ToolTip;

}

void
kbfxvista::saveConfig ()
{

  ConfigInit ().m_KbfxNormalButtonPath = skin;
  ConfigInit ().m_KbfxHoverButtonPath = skin_hover;
  ConfigInit ().m_KbfxPressedButtonPath = skin_pressed;
  ConfigInit ().write ();
 // KbfxCfg::writeConfig ();
}



void
kbfxvista::dropEvent (QDropEvent * e)
{
  e->accept ();
  e->acceptAction ();

  QStrList ls;
  QString filename;
  QUriDrag::decode (e, ls);
  filename = QUriDrag::uriToLocalFile (ls.at (0));
  skin_hover = QUriDrag::uriToLocalFile (ls.at (1));
  skin_pressed = QUriDrag::uriToLocalFile (ls.at (2));
  skin = QUriDrag::uriToLocalFile (ls.at (0));

  QPixmap droped = QImage (filename);
  if (droped.isNull ())
    {
      KMessageBox::information (0, i18n ("Pixmap creation failed"));
      return;
    }
  else
    {
      //FIXME:Code Wanted 
      button->kbfx_vista_button_loadSkins (skin, skin_hover, skin_pressed);
    }

  /* time to se the hiddent images */

  if (kicker_auto_ajust)
    {
      QByteArray data;
      QDataStream arg (data, IO_WriteOnly);
      arg << droped.height ();
      if (!dcop->send ("kicker", "Panel", "setPanelSize(int)", data))
	kdWarning () << "Could not send DCOP command\n";
    }
  // button->kbfx_vista_button_loadSkins (skin,skin_hover,skin_pressed);
  saveConfig ();
  button->repaint ();
}

void
kbfxvista::dragEnterEvent (QDragEnterEvent * e)
{
  //if (QImageDrag::canDecode (e))
  e->accept ();
}

void
kbfxvista::showMenu ()
{
  if (ConfigInit ().m_KbfxMenuType == "kmenu")
    {
      this->showKmenu ();
    }
  else
    {
      kbfxpop (menupos ());
    }
}

void
kbfxvista::showKbfxMenu (QPoint x)
{
  x = x;
  if (ConfigInit ().m_KbfxMenuType == "kmenu")
    {
      this->showKmenu ();
    }
  else
    {
      kbfxpop (menupos ());
    }
  blocked = 0;
  emit leave ();
}

void
kbfxvista::notifyConfigChange ()
{
  readConfig ();
  button->kbfx_vista_button_loadSkins (skin, skin_hover, skin_pressed);
  button->repaint ();
    //qDebug("Re-load Menu with -------->>>>>>"+theme);
  reajust ();;
  menuInit ();
  emit enter ();
  emit leave ();
}
