/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "mainwin.h"

#include <kstandarddirs.h>
#include <dcopref.h>


void
MainWindow::mousePressEvent (QMouseEvent * e)
{
  clickPos = e->pos ();
}

void
MainWindow::mouseMoveEvent (QMouseEvent * e)
{
  //move (e->globalPos () - clickPos);
}




void
MainWindow::formSubmitNotification (const char *action,
				    const QString & url,
				    const QByteArray & formData,
				    const QString & target,
				    const QString & contentType,
				    const QString & boundary)
{
  qDebug (action);
}


void
MainWindow::changeLocation ()
{

}


QString  
MainWindow::getHTMLThemeList(QString path)
{
        QDir d(path);
        d.setFilter( QDir::Dirs );
	QString m_html_string("");
        QString dirname("");
	if(!d.exists ())
 	{
	qDebug("Folder dose not exist");
	return "<Optoin>Invalid Base Path</option";
	}
        const QFileInfoList *list = d.entryInfoList();
        QFileInfoListIterator it( *list );
        QFileInfo *fi;
        while ( (fi = it.current()) != 0 ) {
	if(!fi->fileName().contains("."))
        {    
		m_html_string.append("<option>"+fi->fileName()+"</option>");
	}
            ++it;
        }
return m_html_string;
}


void
MainWindow::openURLRequest (const KURL & url, const KParts::URLArgs & nam)
{

  if (url.query ().contains ("orangepannel"))
    {
      this->handleOrangePannel (url);
      // return ;
    }

  if (url.path ().contains ("index.htm"))
    {

      if (!url.queryItem ("button_normal").isNull ())
	ConfigInit ().m_KbfxNormalButtonPath =
	  url.queryItem ("button_normal");
      if (!url.queryItem ("button_hover").isNull ())
	ConfigInit ().m_KbfxHoverButtonPath = url.queryItem ("button_hover");
      if (!url.queryItem ("button_pressed").isNull ())
	ConfigInit ().m_KbfxPressedButtonPath =
	  url.queryItem ("button_pressed");
      ConfigInit ().write ();

    }
  
if (url.path().contains ("themes"))
    {
     
	if(url.query().contains("basedir"))
	{
	ConfigInit().m_SpinxThemeBasePath ="/"+url.queryItem("basedir") +"/";
        qDebug(url.queryItem("basedir"));
	ConfigInit().write(); 
	}
   	if(url.query().contains("blink"))
	{
        if (url.queryItem ("blink") == "on")
	ConfigInit ().m_SpinxDudeBlink = true;
        else if (url.queryItem ("blink") == "off")
	ConfigInit ().m_SpinxDudeBlink = false;
        ConfigInit ().write ();
	}

	if(url.query().contains("skinname"))
	{
	ConfigInit().m_SpinxThemeName = url.queryItem("skinname");
	ConfigInit().write();
	}	
  
    }
  
 if (url.query ().contains ("tooltip"))
    {
      //fix tooltip 
      if (url.queryItem ("tooltipstat") == "on")
	ConfigInit ().m_ToolTipAnimation = true;
      else if (url.queryItem ("tooltipstat") == "off")
	ConfigInit ().m_ToolTipAnimation = false;
      ConfigInit ().write ();
    }
  if (url.query ().contains ("tooltiptext"))
    {
      ConfigInit ().m_ToolTipText = url.queryItem ("tooltiptext");
      ConfigInit ().write ();
    }
  if(url.query().contains("gifname"))
 {
	ConfigInit().m_ToolTipAvatar = url.queryItem("gifname");
 	ConfigInit().write();
 }

 if(url.query().contains("type"))
 {
	ConfigInit().m_KbfxMenuType = url.queryItem("type");
	ConfigInit().write();	


 }


loadHTML (url.path ());
browser->openURL (KURL (QDir::homeDirPath()+"/.kbfx.html"));

}



void
MainWindow::handleOrangePannel (const KURL & url)
{

  if (url.queryItem ("orangepannel") == "exit")
    {
      qDebug ("Saving settings");
      emit shutdown ();
      return;
    }
  else if (url.queryItem ("orangepannel") == "reload")
    {
      DCOPRef m_kickerkbfxInterface ("kicker", "kbfxInterface");
      m_kickerkbfxInterface.call ("notifyConfigChange()");
      m_kickerkbfxInterface.call ("showMenu()");
    }
  else if (url.queryItem ("orangepannel") == "save")
    {
	ConfigInit().write();
      //TODO:write all defalts 
    }


}


void
MainWindow::parseHTML ()
{
  QString prefix = locate ("data", "kbfx/style.css");
  prefix.replace ("style.css", "");
//Ur Tags

  HTML->replace ("$NORMAL$", ConfigInit ().m_KbfxNormalButtonPath);
  HTML->replace ("$HOVER$", ConfigInit ().m_KbfxHoverButtonPath);
  HTML->replace ("$PRESSED$", ConfigInit ().m_KbfxPressedButtonPath);
//      HTML->replace("$prefix$",prefix);

//HTML settings
  if (ConfigInit ().m_ToolTipAnimation)
    HTML->replace ("$TOOLTIPSTAT$", "On");
  else
    HTML->replace ("$TOOLTIPSTAT$", "Off");

  if(ConfigInit().m_SpinxDudeBlink)
	HTML->replace ("$BLINKSTAT$","On");
  else
	HTML->replace ("$BLINKSTAT$","Off");
  

  HTML->replace ("$TOOLTIPTEXT$", ConfigInit ().m_ToolTipText);

  if(ConfigInit().m_KbfxMenuType == "spinx")
   {
   HTML->replace("$SPINX$","checked");
   HTML->replace("$KMENU$","");
   }
  else
  {
   HTML->replace("$SPINX$","");
   HTML->replace("$KMENU$","checked");
  }

  HTML->replace ("style.css", prefix + "style.css");
  HTML->replace ("oodomimagerollover.js", prefix + "oodomimagerollover.js");
  HTML->replace ("#", prefix + "/index.htm");
  HTML->replace ("$prefix", prefix + "");
  HTML->replace (QRegExp ("images/"), prefix + "images/");
///Genorate theme list
	HTML->replace("$BASEPATH$",ConfigInit().m_SpinxThemeBasePath);
	HTML->replace("$THEMELIST$",getHTMLThemeList(ConfigInit().m_SpinxThemeBasePath));

}


void
MainWindow::loadHTML (QString url)
{


//  FILE *file = fopen (url.ascii (), "r");
  QFile file(url);
  if (!file.open(IO_ReadOnly))
    {
      qDebug ("File Not Found ");
      qDebug (url);
    }
  else
    {

      ssize_t read;
      char *line = 0;
      size_t len;
      QString tmp ("");
      QTextStream stream (&file);
while(!stream.atEnd())
{
tmp.append(stream.readLine());
}
//stream.close();

/*
BUG:
want compile on FreeBSD?
      while ((read = getline (&line, &len, file)) != -1)
	{
	  tmp.append (line);
	}
*/

      HTML = new QString (tmp);
      parseHTML ();
//write HTML to a tmp location
      QFile out (QDir::homeDirPath()+"/.kbfx.html");
      out.open (IO_WriteOnly);
      out.writeBlock (HTML->ascii (), qstrlen (HTML->ascii ()));
      out.close ();
      //     printf ("%s", HTML->ascii ());

    }

}


MainWindow::MainWindow (QWidget  * parent   , const char *name):
QWidget (parent, name, Qt::WStyle_Customize | Qt::WStyle_NoBorder)
{
  qDebug ("Normal=" + ConfigInit ().m_KbfxNormalButtonPath);
  resize (530, 410);
  browser = new KHTMLPart (this);
  qDebug (locate ("data", "kbfx/index.htm"));
  KURL url (locate ("data", "kbfx/index.htm"));
  qDebug("Path is ======>>>"+url.path());
  loadHTML (url.path ());

  browser->openURL (KURL (QDir::homeDirPath()+"/.kbfx.html"));
  browser->view ()->resize (528, 410);
  browser->view ()->move (0, 0);
  browser->view()->setVScrollBarMode(QScrollView::AlwaysOff);
  browser->view()->setHScrollBarMode(QScrollView::AlwaysOff);
  connect (browser->browserExtension (),
	   SIGNAL (openURLRequest (const KURL &, const KParts::URLArgs &)),
	   this,
	   SLOT (openURLRequest (const KURL &, const KParts::URLArgs &)));
  connect (browser,
	   SIGNAL (formSubmitNotification
		   (const char *, const QString &, const QByteArray &,
		    const QString &, const QString &, const QString &)), this,
	   SLOT (formSubmitNotification
		 (const char *, const QString &, const QByteArray &,
		  const QString &, const QString &, const QString &)));


}



//#include "mainwin.moc.cpp"
